/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.form.schedule;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;

public class Time12HrFmt
implements Serializable {
    private static final long serialVersionUID = -5569353959041715547L;
    public static final String COLON = ":";
    public static final String ZERO = "0";
    private String time;
    private String meridiem;

    public Time12HrFmt(Timestamp day) {
        this.parseTimeTo12HrFmt(day);
    }

    public Time12HrFmt(String time, MERIDIEM meridiem) {
        this.time = time;
        this.meridiem = meridiem.toString();
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getMeridiem() {
        return this.meridiem;
    }

    public void setMeridiem(String meridiem) {
        this.meridiem = meridiem;
    }

    private void parseTimeTo12HrFmt(Timestamp day) {
        String str;
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(day);
        this.meridiem = cl.get(9) == 0 ? MERIDIEM.AM.name() : MERIDIEM.PM.name();
        int hr = cl.get(11);
        hr = hr == 0 ? 12 : hr;
        hr = hr > 12 ? hr - 12 : hr;
        int min = cl.get(12);
        this.time = str = this.buildDisplayView(hr, min);
    }

    private String buildDisplayView(int hrs, int mins) {
        StringBuilder str = new StringBuilder();
        if (hrs < 10) {
            str.append(ZERO).append(hrs);
        } else {
            str.append(hrs);
        }
        str.append(COLON);
        if (mins < 10) {
            str.append(ZERO).append(mins);
        } else {
            str.append(mins);
        }
        return str.toString();
    }

    public int findMinutes() {
        String[] result = this.time.split(COLON);
        int hrs = new Integer(result[0]);
        int min = new Integer(result[1]);
        boolean am_pm = false;
        if (this.meridiem.equalsIgnoreCase(MERIDIEM.AM.toString())) {
            am_pm = true;
        }
        int mins = 0;
        mins = hrs == 12 ? 0 + min + (am_pm ? 0 : 720) : hrs * 60 + min + (am_pm ? 0 : 720);
        return mins;
    }
}

