/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class AbstractConfigurer
extends ModuleConfigurer
implements SmartApplicationListener {
    private String moduleTitle;

    public AbstractConfigurer(String moduleName, String moduleTitle) {
        super(moduleName);
        this.moduleTitle = moduleTitle;
    }

    public String getModuleTitle() {
        return this.moduleTitle;
    }

    public void setModuleTitle(String moduleTitle) {
        this.moduleTitle = moduleTitle;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.loadDataDictionary();
            this.publishDataDictionaryComponents();
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return true;
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public int getOrder() {
        return -1000;
    }

    protected void loadDataDictionary() {
        if (this.isLoadDataDictionary()) {
            this.LOG.info((Object)(this.getModuleTitle() + " Configurer - Loading DD"));
            DataDictionaryService dds = KRADServiceLocatorWeb.getDataDictionaryService();
            if (dds == null) {
                dds = (DataDictionaryService)GlobalResourceLoader.getService((String)"dataDictionaryService");
            }
            dds.getDataDictionary().parseDataDictionaryConfigurationFiles(false);
            if (this.isValidateDataDictionary()) {
                this.LOG.info((Object)(this.getModuleTitle() + " Configurer - Validating DD"));
                dds.getDataDictionary().validateDD(this.isValidateDataDictionaryEboReferences());
            }
            dds.getDataDictionary().performBeanOverrides();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishDataDictionaryComponents() {
        if (this.isComponentPublishingEnabled()) {
            long delay = this.getComponentPublishingDelay();
            this.LOG.info((Object)("Publishing of Data Dictionary components is enabled, scheduling publish after " + delay + " millisecond delay"));
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            try {
                scheduler.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, delay, TimeUnit.MILLISECONDS);
            }
            finally {
                scheduler.shutdown();
            }
        }
    }

    public boolean isLoadDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("load.data.dictionary", true);
    }

    public boolean isValidateDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("validate.data.dictionary", false);
    }

    public boolean isValidateDataDictionaryEboReferences() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("validate.data.dictionary.ebo.references", false);
    }

    public boolean isComponentPublishingEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.componentPublishing.enabled", false);
    }

    public long getComponentPublishingDelay() {
        return ConfigContext.getCurrentContextConfig().getNumericProperty("rice.krad.componentPublishing.delay", 0L);
    }

    static /* synthetic */ Logger access$000(AbstractConfigurer x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$100(AbstractConfigurer x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$200(AbstractConfigurer x0) {
        return x0.LOG;
    }
}

