/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.customattributes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cxf.common.util.StringUtils;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.common.customattributes.CustomDataHelperBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CustomDataHelperBase<T extends DocumentCustomData>
implements Serializable {
    private SortedMap<String, List> customAttributeGroups = new TreeMap();
    private boolean modifyCustomData = false;

    public void buildCustomDataCollectionsOnExistingDocument(SortedMap<String, List> customAttributeGroups) {
        for (Map.Entry customAttributeDocumentEntry : this.getCustomAttributeDocuments().entrySet()) {
            DocumentCustomData loopAwardCustomData = null;
            for (DocumentCustomData awardCustomData : this.getCustomDataList()) {
                if (awardCustomData.getCustomAttributeId() != (long)((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute().getId().intValue()) continue;
                loopAwardCustomData = awardCustomData;
                break;
            }
            if (loopAwardCustomData == null) continue;
            String groupName = ((CustomAttributeDocument)this.getCustomAttributeDocuments().get(loopAwardCustomData.getCustomAttributeId().toString())).getCustomAttribute().getGroupName();
            ArrayList customAttributeDocumentList = (ArrayList)customAttributeGroups.get(groupName);
            if (customAttributeDocumentList == null) {
                customAttributeDocumentList = new ArrayList();
                customAttributeGroups.put(groupName, customAttributeDocumentList);
            }
            customAttributeDocumentList.add(this.getCustomAttributeDocuments().get(loopAwardCustomData.getCustomAttributeId().toString()));
            Collections.sort(customAttributeDocumentList, new LabelComparator(this));
        }
    }

    public void buildCustomDataCollectionsOnNewDocument(SortedMap<String, List> customAttributeGroups) {
        for (Map.Entry customAttributeDocumentEntry : this.getCustomAttributeDocuments().entrySet()) {
            ArrayList customAttributeDocumentList;
            String temp = ((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute().getValue();
            String groupName = ((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute().getGroupName();
            DocumentCustomData newCustomData = this.getNewCustomData();
            newCustomData.setCustomAttribute(((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute());
            newCustomData.setCustomAttributeId(Long.valueOf(((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttributeId().longValue()));
            newCustomData.setValue(((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute().getDefaultValue());
            this.getCustomDataList().add(newCustomData);
            if (StringUtils.isEmpty((String)groupName)) {
                groupName = "No Group";
            }
            if ((customAttributeDocumentList = (ArrayList)customAttributeGroups.get(groupName)) == null) {
                customAttributeDocumentList = new ArrayList();
                customAttributeGroups.put(groupName, customAttributeDocumentList);
            }
            customAttributeDocumentList.add(this.getCustomAttributeDocuments().get(((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttributeId().toString()));
            Collections.sort(customAttributeDocumentList, new LabelComparator(this));
        }
    }

    public void prepareCustomData() {
        this.initializePermissions();
        TreeMap customAttributeGroups = new TreeMap();
        if (this.getCustomDataList().size() > 0) {
            this.buildCustomDataCollectionsOnExistingDocument(customAttributeGroups);
        } else {
            this.buildCustomDataCollectionsOnNewDocument(customAttributeGroups);
        }
        this.setCustomAttributeGroups(customAttributeGroups);
    }

    protected abstract T getNewCustomData();

    public abstract List<T> getCustomDataList();

    public abstract Map<String, CustomAttributeDocument> getCustomAttributeDocuments();

    public String getValidCustomAttributeGroupName(String groupName) {
        return groupName != null ? groupName : "Custom Data Group";
    }

    public void initializePermissions() {
        this.modifyCustomData = this.canModifyCustomData();
    }

    public boolean canModifyCustomData() {
        return this.modifyCustomData;
    }

    public boolean getModifyCustomData() {
        return this.modifyCustomData;
    }

    public void setCustomAttributeGroups(SortedMap<String, List> customAttributeGroups) {
        this.customAttributeGroups = customAttributeGroups;
    }

    public Map<String, List> getCustomAttributeGroups() {
        return this.customAttributeGroups;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void setCustomAttributeContent(String documentNumber, String attributeName) {
        this.getCustomAttributeService().setCustomAttributeKeyValue(documentNumber, this.getCustomAttributeDocuments(), attributeName, this.getUserIdentifier());
    }

    protected CustomAttributeService getCustomAttributeService() {
        return (CustomAttributeService)KraServiceLocator.getService(CustomAttributeService.class);
    }
}

