/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.common.notification.KcNotificationAuthorizationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class NotificationMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        Set actions = this.getDocumentActions(document);
        actions = super.getDocumentActions(document, user, actions);
        return actions;
    }

    protected Set<String> getDocumentActions(Document document) {
        boolean hasViewPermission;
        Set documentActions = new HashSet();
        boolean hasModifyPermission = this.getKcNotificationAuthorizationService().hasPermission("Modify Notification");
        boolean bl = hasViewPermission = hasModifyPermission || this.getKcNotificationAuthorizationService().hasPermission("View Notification");
        if (hasModifyPermission) {
            documentActions = this.getDocumentActionsWithModifyPermission(document);
        } else if (hasViewPermission) {
            documentActions = this.getDocumentActionsWithViewPermission(document);
        } else {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Edit/View", "Notification");
        }
        return documentActions;
    }

    private KcNotificationAuthorizationService getKcNotificationAuthorizationService() {
        return (KcNotificationAuthorizationService)KraServiceLocator.getService(KcNotificationAuthorizationService.class);
    }

    private Set<String> getDocumentActionsWithModifyPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved()) {
            documentActions.add("canEdit");
            documentActions.add("canEditDocumentOverview");
            documentActions.add("canSave");
            documentActions.add("canClose");
            documentActions.add("canCancel");
            documentActions.add("canBlanketApprove");
            documentActions.add("canRoute");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }

    private Set<String> getDocumentActionsWithViewPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        String maintAction = ((MaintenanceDocumentBase)document).getNewMaintainableObject().getMaintenanceAction();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            if (maintAction.equals("Copy")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Copy", "Notification");
            }
            if (maintAction.equals("New")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Create", "Notification");
            }
            documentActions.add("canReload");
            documentActions.add("canClose");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }
}

