/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class NotificationRendererBase
implements NotificationRenderer,
Serializable {
    private static final long serialVersionUID = 7355369114077509177L;
    public static final String USER_FULLNAME = "{USER_FULLNAME}";
    public static final String DOCHANDLER_PREFIX = "{DOCUMENT_PREFIX}";
    public static final String RICE_SERVER_URL = "rice.server.url";
    public static final String APP_LINK_PREFIX = "{APP_LINK_PREFIX}";
    public static final String APPLICATION_URL_PARM = "application.url";
    private transient KcPersonService kcPersonService;
    private ConfigurationService kualiConfigurationService;

    public String render(String text) {
        return this.render(text, this.getDefaultReplacementParameters());
    }

    protected String render(String text, Map<String, String> replacementParameters) {
        for (String key : replacementParameters.keySet()) {
            text = StringUtils.replace((String)text, (String)key, (String)replacementParameters.get(key));
        }
        return text;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (GlobalVariables.getUserSession() != null) {
            params.put(USER_FULLNAME, this.getKcPersonService().getKcPersonByPersonId(GlobalVariables.getUserSession().getPrincipalId()).getFullName());
        }
        params.put(DOCHANDLER_PREFIX, this.getDocumentLocation());
        params.put(APP_LINK_PREFIX, this.getApplicationLinkPrefix());
        return params;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected String getSafeMessage(String key, String message) {
        if (StringUtils.isBlank((String)message)) {
            message = "(No value set for " + key + " in this action)";
        }
        return message;
    }

    private String getDocumentLocation() {
        return this.getKualiConfigurationService().getPropertyValueAsString(RICE_SERVER_URL);
    }

    private String getApplicationLinkPrefix() {
        String retVal = null;
        retVal = this.getKualiConfigurationService().getPropertyValueAsString(APPLICATION_URL_PARM);
        if (retVal == null) {
            retVal = "..";
        }
        return retVal;
    }

    private ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }
}

