/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.kra.common.notification.lookup.keyvalue.KeyLabelSortByValue;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class NotificationModuleRoleRoleNameValuesFinder
extends KeyValuesBase {
    private KeyValuesService keyValuesService;

    public List<KeyValue> getKeyValues() {
        Collection roles = this.getKeyValuesService().findAll(RoleEbo.class);
        ArrayList<KeyLabelSortByValue> keyValues = new ArrayList<KeyLabelSortByValue>();
        keyValues.add(new KeyLabelSortByValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        for (RoleEbo role : roles) {
            String roleKey = role.getNamespaceCode() + ":" + role.getName();
            keyValues.add(new KeyLabelSortByValue(roleKey, roleKey));
        }
        Collections.sort(keyValues);
        ArrayList<KeyValue> returnKeyValues = new ArrayList<KeyValue>();
        returnKeyValues.addAll(keyValues);
        return returnKeyValues;
    }

    public KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KraServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }
}

