/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NotificationTypeMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String MODULE_CODE_FIELD_NAME = "moduleCode";
    private static final String ACTION_CODE_FIELD_NAME = "actionCode";
    private static final String ROLE_FIELD_NAME = "notificationTypeRecipients[%d].roleName";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument document) {
        boolean isValid = true;
        NotificationType newNotificationType = (NotificationType)document.getNewMaintainableObject().getDataObject();
        isValid &= this.checkModuleCodeActionCodeUniqueness(newNotificationType);
        return isValid &= this.checkNotificationTypeIdRoleNameUniqueness(newNotificationType);
    }

    private boolean checkModuleCodeActionCodeUniqueness(NotificationType newNotificationType) {
        boolean isValid = true;
        String moduleCode = newNotificationType.getModuleCode();
        String actionCode = newNotificationType.getActionCode();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE_FIELD_NAME, moduleCode);
        fieldValues.put(ACTION_CODE_FIELD_NAME, actionCode);
        Collection matchingNotificationTypes = this.getBusinessObjectService().findMatching(NotificationType.class, fieldValues);
        for (NotificationType matchingNotificationType : matchingNotificationTypes) {
            if (ObjectUtils.equals((Object)newNotificationType.getNotificationTypeId(), (Object)matchingNotificationType.getNotificationTypeId())) continue;
            isValid = false;
            this.putFieldError(ACTION_CODE_FIELD_NAME, "error.notification.moduleCode.actionCode.combination.exists", new String[]{moduleCode, actionCode});
            break;
        }
        return isValid;
    }

    private boolean checkNotificationTypeIdRoleNameUniqueness(NotificationType newNotificationType) {
        boolean isValid = true;
        List newNotificationTypeRecipients = newNotificationType.getNotificationTypeRecipients();
        ListIterator outer = newNotificationTypeRecipients.listIterator();
        while (outer.hasNext()) {
            NotificationTypeRecipient outerNotificationTypeRecipient = (NotificationTypeRecipient)outer.next();
            ListIterator inner = newNotificationTypeRecipients.listIterator(outer.nextIndex());
            while (inner.hasNext()) {
                int currentIndex = inner.nextIndex();
                NotificationTypeRecipient innerNotificationTypeRecipient = (NotificationTypeRecipient)inner.next();
                if (!StringUtils.equals((String)outerNotificationTypeRecipient.getRoleName(), (String)innerNotificationTypeRecipient.getRoleName()) || !StringUtils.equals((String)outerNotificationTypeRecipient.getRoleSubQualifier(), (String)innerNotificationTypeRecipient.getRoleSubQualifier())) continue;
                isValid = false;
                this.putFieldError(String.format(ROLE_FIELD_NAME, currentIndex), "error.notification.roleNamespace.roleName.exists", new String[]{innerNotificationTypeRecipient.getRoleName()});
            }
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

