/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.permissions.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.web.bean.Role;
import org.kuali.kra.common.permissions.web.bean.RoleState;

public class UserState
implements Serializable {
    private KcPerson person;
    private List<RoleState> roleStates = new ArrayList();

    public UserState(KcPerson person, List<Role> roles) {
        this.person = person;
        for (Role role : roles) {
            this.roleStates.add(new RoleState(role));
        }
    }

    public KcPerson getPerson() {
        return this.person;
    }

    public List<RoleState> getRoleStates() {
        return this.roleStates;
    }

    public void setSaved(String roleName, boolean saved) {
        for (RoleState roleState : this.roleStates) {
            if (!StringUtils.equals((String)roleState.getRole().getName(), (String)roleName)) continue;
            roleState.setSaved(saved);
        }
    }

    public void setAssigned(String roleName, boolean assigned) {
        for (RoleState roleState : this.roleStates) {
            if (!StringUtils.equals((String)roleState.getRole().getName(), (String)roleName)) continue;
            roleState.setAssigned(assigned);
        }
    }

    public boolean isRoleAssigned(String roleName) {
        for (RoleState roleState : this.roleStates) {
            if (!StringUtils.equals((String)roleState.getRole().getName(), (String)roleName)) continue;
            return roleState.isAssigned();
        }
        return false;
    }

    public void clearAssignments() {
        for (RoleState roleState : this.roleStates) {
            roleState.setAssigned(false);
        }
    }

    public boolean hasAnyRole() {
        for (RoleState roleState : this.roleStates) {
            if (!roleState.isAssigned()) continue;
            return true;
        }
        return false;
    }
}

