/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.printing;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.common.printing.ReportBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.web.ui.Column;

public class CurrentReportBean
extends ReportBean {
    private String awardNumber;
    private String sponsorName;
    private String roleCode;
    private String awardTitle;
    private KualiDecimal awardAmount;
    private Date projectStartDate;
    private Date projectEndDate;
    private KualiDecimal academicYearEffort;
    private KualiDecimal calendarYearEffort;
    private KualiDecimal summerEffort;
    private KualiDecimal totalEffort;
    private String sponsorAwardNumber;
    private KualiDecimal totalDirectCostTotal;
    private KualiDecimal totalIndirectCostTotal;
    private List<AwardCustomData> awardCustomDataList;
    private ParameterService parameterService;
    protected static final String ROOT_AWARD_NUMBER_PARAMETER = "rootAwardNumber";

    public CurrentReportBean(AwardPerson awardPerson) {
        this.roleCode = awardPerson.getRoleCode();
        this.academicYearEffort = awardPerson.getAcademicYearEffort();
        this.calendarYearEffort = awardPerson.getCalendarYearEffort();
        this.summerEffort = awardPerson.getSummerEffort();
        this.totalEffort = awardPerson.getTotalEffort();
        Award award = awardPerson.getAward();
        this.awardNumber = award.getAwardNumber();
        this.sponsorName = award.getSponsorName();
        this.sponsorAwardNumber = award.getSponsorCode();
        this.awardTitle = award.getTitle();
        this.awardAmount = award.calculateObligatedDistributedAmountTotal();
        this.projectStartDate = award.getAwardEffectiveDate();
        this.projectEndDate = award.findLatestFinalExpirationDate();
        this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
            if (!directIndirectEnabledValue.equals("1")) continue;
            this.totalDirectCostTotal = awardAmountInfo.getObligatedTotalDirect();
            this.totalIndirectCostTotal = awardAmountInfo.getObligatedTotalIndirect();
        }
        this.awardCustomDataList = new ArrayList();
        String customGroupName = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "CURRENT_PENDING_REPORT_GROUP_NAME");
        for (AwardCustomData awardcutomdata : award.getAwardCustomDataList()) {
            if (awardcutomdata.getCustomAttribute() == null || !awardcutomdata.getCustomAttribute().getGroupName().equals(customGroupName)) continue;
            this.awardCustomDataList.add(awardcutomdata);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrentReportBean)) {
            return false;
        }
        return this.awardNumber.equals(((CurrentReportBean)o).awardNumber);
    }

    public KualiDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public KualiDecimal getAwardAmount() {
        return this.awardAmount;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public String getAwardTitle() {
        return this.awardTitle;
    }

    public KualiDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public Date getProjectEndDate() {
        return this.projectEndDate;
    }

    public Date getProjectStartDate() {
        return this.projectStartDate;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public KualiDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public int hashCode() {
        return this.awardNumber.hashCode();
    }

    protected List<Column> createColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.createColumn("Sponsor Award ID", "sponsorAwardNumber", (Object)this.sponsorAwardNumber, String.class));
        columns.add(this.createColumn("Sponsor", "sponsorName", (Object)this.sponsorName, String.class));
        columns.add(this.createColumn("Role", "roleCode", (Object)this.roleCode, String.class));
        columns.add(this.createColumn("Title", "awardTitle", (Object)this.awardTitle, String.class));
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            columns.add(this.createColumn("Total Direct Cost", "totalDirectCostTotal", (Object)this.totalDirectCostTotal, KualiDecimal.class));
            columns.add(this.createColumn("Total F&A Cost", "totalIndirectCostTotal", (Object)this.totalIndirectCostTotal, KualiDecimal.class));
        }
        columns.add(this.createColumn("Award Amount", "awardAmount", (Object)this.awardAmount, KualiDecimal.class));
        columns.add(this.createColumn("Effective Date", "projectStartDate", (Object)this.projectStartDate, Date.class));
        columns.add(this.createColumn("End Date", "projectEndDate", (Object)this.projectEndDate, Date.class));
        columns.add(this.createColumn("Effort %", "totalEffort", (Object)this.totalEffort, KualiDecimal.class));
        columns.add(this.createColumn("Academic Year Effort %", "academicYearEffort", (Object)this.academicYearEffort, KualiDecimal.class));
        columns.add(this.createColumn("Summer Effort %", "summerEffort", (Object)this.summerEffort, KualiDecimal.class));
        columns.add(this.createColumn("Calendar Year Effort %", "calendarYearEffort", (Object)this.calendarYearEffort, KualiDecimal.class));
        if (this.awardCustomDataList.size() > 0) {
            for (AwardCustomData awardcutomdata : this.awardCustomDataList) {
                columns.add(this.createColumn(awardcutomdata.getCustomAttribute().getLabel(), "awardCustomDataList", (Object)awardcutomdata.getValue(), String.class));
            }
        }
        return columns;
    }

    public void setTotalEffort(KualiDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public KualiDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setTotalDirectCostTotal(KualiDecimal totalDirectCostTotal) {
        this.totalDirectCostTotal = totalDirectCostTotal;
    }

    public KualiDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public void setTotalIndirectCostTotal(KualiDecimal totalIndirectCostTotal) {
        this.totalIndirectCostTotal = totalIndirectCostTotal;
    }

    public KualiDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public void setAwardCustomDataList(List<AwardCustomData> awardCustomDataList) {
        this.awardCustomDataList = awardCustomDataList;
    }

    public List<AwardCustomData> getAwardCustomDataList() {
        return this.awardCustomDataList;
    }
}

