/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.printing;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.common.printing.ReportBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.web.ui.Column;

public class PendingReportBean
extends ReportBean {
    private String proposalNumber;
    private String sponsorName;
    private String roleCode;
    private String proposalTitle;
    private KualiDecimal totalDirectCostTotal;
    private KualiDecimal totalIndirectCostTotal;
    private Date requestedStartDateInitial;
    private Date requestedEndDateTotal;
    private KualiDecimal academicYearEffort;
    private KualiDecimal calendarYearEffort;
    private KualiDecimal summerEffort;
    private KualiDecimal totalEffort;
    private ParameterService parameterService;
    private List<InstitutionalProposalCustomData> institutionalProposalCustomDataList;

    public PendingReportBean(InstitutionalProposalPerson ipPerson) {
        InstitutionalProposal proposal = ipPerson.getInstitutionalProposal();
        this.proposalNumber = proposal.getProposalNumber();
        this.sponsorName = proposal.getSponsorName();
        this.roleCode = ipPerson.getRoleCode();
        this.proposalTitle = proposal.getTitle();
        this.totalDirectCostTotal = proposal.getTotalDirectCostTotal();
        this.totalIndirectCostTotal = proposal.getTotalIndirectCostTotal();
        this.requestedStartDateInitial = proposal.getRequestedStartDateInitial();
        this.requestedEndDateTotal = proposal.getRequestedEndDateTotal();
        this.academicYearEffort = ipPerson.getAcademicYearEffort();
        this.calendarYearEffort = ipPerson.getCalendarYearEffort();
        this.summerEffort = ipPerson.getSummerEffort();
        this.totalEffort = ipPerson.getTotalEffort();
        this.institutionalProposalCustomDataList = new ArrayList();
        this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        String customGroupName = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "CURRENT_PENDING_REPORT_GROUP_NAME");
        for (InstitutionalProposalCustomData custData : proposal.getInstitutionalProposalCustomDataList()) {
            if (custData.getCustomAttributeId() == null) continue;
            custData.setCustomAttribute(proposal.getInstitutionalProposalDocument().getCustomAttributeDocument(custData.getCustomAttributeId().toString()).getCustomAttribute());
            if (!customGroupName.equals(custData.getCustomAttribute().getGroupName())) continue;
            this.institutionalProposalCustomDataList.add(custData);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PendingReportBean)) {
            return false;
        }
        PendingReportBean that = (PendingReportBean)o;
        return this.proposalNumber.equals(that.proposalNumber);
    }

    public KualiDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public KualiDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public String getProposalTitle() {
        return this.proposalTitle;
    }

    public Date getRequestedEndDateTotal() {
        return this.requestedEndDateTotal;
    }

    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public KualiDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public KualiDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public KualiDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public KualiDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public KualiDecimal getTotalRequestedCost() {
        return (KualiDecimal)this.totalDirectCostTotal.add((AbstractKualiDecimal)this.totalIndirectCostTotal);
    }

    public int hashCode() {
        return this.proposalNumber.hashCode();
    }

    protected List<Column> createColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.createColumn("Proposal Number", "proposalNumber", (Object)this.proposalNumber, String.class));
        columns.add(this.createColumn("Agency", "sponsorName", (Object)this.sponsorName, String.class));
        columns.add(this.createColumn("Role", "roleCode", (Object)this.roleCode, String.class));
        columns.add(this.createColumn("Title", "proposalTitle", (Object)this.proposalTitle, String.class));
        columns.add(this.createColumn("Total Direct Cost", "totalDirectCostTotal", (Object)this.totalDirectCostTotal, KualiDecimal.class));
        columns.add(this.createColumn("Total F&A Cost", "totalIndirectCostTotal", (Object)this.totalIndirectCostTotal, KualiDecimal.class));
        columns.add(this.createColumn("Total Requested Cost", "totalRequestedCost", (Object)this.getTotalRequestedCost(), KualiDecimal.class));
        columns.add(this.createColumn("Effective Date", "requestedStartDateInitial", (Object)this.requestedStartDateInitial, Date.class));
        columns.add(this.createColumn("End Date", "requestedEndDateTotal", (Object)this.requestedEndDateTotal, Date.class));
        columns.add(this.createColumn("% Effort", "totalEffort", (Object)this.totalEffort, KualiDecimal.class));
        columns.add(this.createColumn("Academic Year Effort %", "academicYearEffort", (Object)this.academicYearEffort, KualiDecimal.class));
        columns.add(this.createColumn("Summer Year Effort %", "summerYearEffort", (Object)this.summerEffort, KualiDecimal.class));
        columns.add(this.createColumn("Calendar Year Effort %", "calendarYearEffort", (Object)this.calendarYearEffort, KualiDecimal.class));
        if (this.institutionalProposalCustomDataList.size() > 0) {
            for (InstitutionalProposalCustomData institutionalProposalCustomData : this.institutionalProposalCustomDataList) {
                columns.add(this.createColumn(institutionalProposalCustomData.getCustomAttribute().getLabel(), "institutionalProposalCustomDataList", (Object)institutionalProposalCustomData.getValue(), String.class));
            }
        }
        return columns;
    }

    public void setInstitutionalProposalCustomDataList(List<InstitutionalProposalCustomData> institutionalProposalCustomDataList) {
        this.institutionalProposalCustomDataList = institutionalProposalCustomDataList;
    }

    public List<InstitutionalProposalCustomData> getInstitutionalProposalCustomDataList() {
        return this.institutionalProposalCustomDataList;
    }
}

