/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.SpecialReviewApprovalType;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;

public abstract class SpecialReview<T extends SpecialReviewExemption>
extends KraPersistableBusinessObjectBase {
    private static final long serialVersionUID = -2168706171397009621L;
    private Integer specialReviewNumber;
    private String specialReviewTypeCode;
    private String approvalTypeCode;
    private String protocolNumber;
    private Date applicationDate;
    private Date approvalDate;
    private Date expirationDate;
    private String comments;
    private SpecialReviewType specialReviewType;
    private SpecialReviewApprovalType approvalType;
    private String protocolStatus;
    private List<T> specialReviewExemptions = new ArrayList();
    private transient List<String> exemptionTypeCodes = new ArrayList();

    public Integer getSpecialReviewNumber() {
        return this.specialReviewNumber;
    }

    public void setSpecialReviewNumber(Integer specialReviewNumber) {
        this.specialReviewNumber = specialReviewNumber;
    }

    public String getSpecialReviewTypeCode() {
        return this.specialReviewTypeCode;
    }

    public void setSpecialReviewTypeCode(String specialReviewTypeCode) {
        this.specialReviewTypeCode = specialReviewTypeCode;
    }

    public String getApprovalTypeCode() {
        return this.approvalTypeCode;
    }

    public void setApprovalTypeCode(String approvalTypeCode) {
        this.approvalTypeCode = approvalTypeCode;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public List<T> getSpecialReviewExemptions() {
        return this.specialReviewExemptions;
    }

    public void setSpecialReviewExemptions(List<T> specialReviewExemptions) {
        this.specialReviewExemptions = specialReviewExemptions;
        this.syncSpecialReviewExemptionsToExemptionTypeCodes();
    }

    public SpecialReviewType getSpecialReviewType() {
        return this.specialReviewType;
    }

    public void setSpecialReviewType(SpecialReviewType specialReviewType) {
        this.specialReviewType = specialReviewType;
    }

    public SpecialReviewApprovalType getApprovalType() {
        return this.approvalType;
    }

    public void setApprovalType(SpecialReviewApprovalType approvalType) {
        this.approvalType = approvalType;
    }

    public List<String> getExemptionTypeCodes() {
        return this.exemptionTypeCodes;
    }

    public void setExemptionTypeCodes(List<String> exemptionTypeCodes) {
        this.exemptionTypeCodes = exemptionTypeCodes;
        this.syncExemptionTypeCodesToSpecialReviewExemptions();
    }

    public String getProtocolStatus() {
        return this.protocolStatus;
    }

    public void setProtocolStatus(String protocolStatus) {
        this.protocolStatus = protocolStatus;
    }

    protected void postLoad() {
        super.postLoad();
        this.syncSpecialReviewExemptionsToExemptionTypeCodes();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getSpecialReviewExemptions());
        return managedLists;
    }

    public abstract T createSpecialReviewExemption(String var1);

    private void syncExemptionTypeCodesToSpecialReviewExemptions() {
        ArrayList<SpecialReviewExemption> syncedSpecialReviewExemptions = new ArrayList<SpecialReviewExemption>();
        if (this.exemptionTypeCodes != null) {
            for (String exemptionTypeCode : this.exemptionTypeCodes) {
                syncedSpecialReviewExemptions.add(this.getSpecialReviewExemption(exemptionTypeCode));
            }
        }
        this.specialReviewExemptions = new ArrayList(syncedSpecialReviewExemptions);
    }

    private T getSpecialReviewExemption(String exemptionTypeCode) {
        SpecialReviewExemption specialReviewExemption = null;
        if (this.specialReviewExemptions != null) {
            for (SpecialReviewExemption exemption : this.specialReviewExemptions) {
                if (!StringUtils.equals((String)exemption.getExemptionTypeCode(), (String)exemptionTypeCode)) continue;
                specialReviewExemption = exemption;
                break;
            }
        }
        if (specialReviewExemption == null) {
            specialReviewExemption = this.createSpecialReviewExemption(exemptionTypeCode);
        }
        return (T)specialReviewExemption;
    }

    private void syncSpecialReviewExemptionsToExemptionTypeCodes() {
        ArrayList<String> syncedExemptionTypeCodes = new ArrayList<String>();
        if (this.specialReviewExemptions != null) {
            for (SpecialReviewExemption exemption : this.specialReviewExemptions) {
                if (exemption.getExemptionTypeCode() == null) continue;
                syncedExemptionTypeCodes.add(exemption.getExemptionTypeCode());
            }
        }
        if (!syncedExemptionTypeCodes.isEmpty()) {
            this.exemptionTypeCodes = new ArrayList(syncedExemptionTypeCodes);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationDate == null ? 0 : this.applicationDate.hashCode());
        result = 31 * result + (this.approvalDate == null ? 0 : this.approvalDate.hashCode());
        result = 31 * result + (this.approvalTypeCode == null ? 0 : this.approvalTypeCode.hashCode());
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        result = 31 * result + (this.protocolNumber == null ? 0 : this.protocolNumber.hashCode());
        result = 31 * result + (this.specialReviewNumber == null ? 0 : this.specialReviewNumber.hashCode());
        result = 31 * result + (this.specialReviewTypeCode == null ? 0 : this.specialReviewTypeCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialReview other = (SpecialReview)obj;
        if (this.applicationDate == null ? other.applicationDate != null : !this.applicationDate.equals(other.applicationDate)) {
            return false;
        }
        if (this.approvalDate == null ? other.approvalDate != null : !this.approvalDate.equals(other.approvalDate)) {
            return false;
        }
        if (this.approvalTypeCode == null ? other.approvalTypeCode != null : !this.approvalTypeCode.equals(other.approvalTypeCode)) {
            return false;
        }
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals(other.expirationDate)) {
            return false;
        }
        if (this.protocolNumber == null ? other.protocolNumber != null : !this.protocolNumber.equals(other.protocolNumber)) {
            return false;
        }
        if (this.specialReviewNumber == null ? other.specialReviewNumber != null : !this.specialReviewNumber.equals(other.specialReviewNumber)) {
            return false;
        }
        return !(this.specialReviewTypeCode == null ? other.specialReviewTypeCode != null : !this.specialReviewTypeCode.equals(other.specialReviewTypeCode));
    }
}

