/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.rules;

import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.ValidSpecialReviewApproval;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;
import org.kuali.kra.common.specialreview.rule.event.AddSpecialReviewEvent;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewEvent;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewLinkEvent;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.CollectionUtils;

public class SpecialReviewRuleBase<T extends SpecialReview<? extends SpecialReviewExemption>>
extends ResearchDocumentRuleBase {
    private static final String TYPE_CODE_FIELD = "specialReviewTypeCode";
    private static final String APPROVAL_TYPE_CODE_FIELD = "approvalTypeCode";
    private static final String PROTOCOL_NUMBER_FIELD = "protocolNumber";
    private static final String PROTOCOL_NUMBER_TITLE = "Protocol Number";
    private static final String APPLICATION_DATE_FIELD = "applicationDate";
    private static final String APPLICATION_DATE_TITLE = "Application Date";
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String APPROVAL_DATE_TITLE = "Approval Date";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String EXPIRATION_DATE_TITLE = "Expiration Date";
    private static final String EXEMPTION_TYPE_CODE_FIELD = "exemptionTypeCodes";
    private static final String EXEMPTION_TYPE_CODE_TITLE = "Exemption #";
    private static final String HUMAN_SUBJECTS_LINK_TO_IRB_ERROR_STRING = "Human Subjects/Link to IRB";
    private static final String ANIMAL_USAGE_LINK_TO_IACUC_ERROR_STRING = "Animal Usage/Link to IACUC";
    private ProtocolFinderDao protocolFinderDao;
    private IacucProtocolFinderDao iacucProtocolFinderDao;

    protected boolean processAddSpecialReviewEvent(AddSpecialReviewEvent<T> addSpecialReviewEvent) {
        boolean rulePassed = true;
        SpecialReview specialReview = addSpecialReviewEvent.getSpecialReview();
        List specialReviews = addSpecialReviewEvent.getSpecialReviews();
        boolean validateProtocol = addSpecialReviewEvent.getIsIrbProtocolLinkingEnabled();
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)specialReview);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        if (validateProtocol && "1".equals(specialReview.getSpecialReviewTypeCode())) {
            rulePassed &= this.validateProtocolNumber(specialReview, specialReviews, HUMAN_SUBJECTS_LINK_TO_IRB_ERROR_STRING);
        } else if (validateProtocol && "2".equals(specialReview.getSpecialReviewTypeCode())) {
            rulePassed &= this.validateProtocolNumber(specialReview, specialReviews, ANIMAL_USAGE_LINK_TO_IACUC_ERROR_STRING);
        } else {
            rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
            rulePassed &= this.validateDateFields(specialReview);
        }
        return rulePassed;
    }

    protected boolean processSaveSpecialReviewLinkEvent(SaveSpecialReviewLinkEvent<T> saveSpecialReviewLinkEvent) {
        boolean rulePassed = true;
        for (SpecialReview specialReview : saveSpecialReviewLinkEvent.getSpecialReviews()) {
            if (!"1".equals(specialReview.getSpecialReviewTypeCode())) continue;
            rulePassed &= this.validateLinkingDocument(specialReview.getProtocolNumber());
        }
        for (String linkedProtocolNumber : saveSpecialReviewLinkEvent.getLinkedProtocolNumbers()) {
            rulePassed &= this.validateLinkingDocument(linkedProtocolNumber);
        }
        return rulePassed;
    }

    protected boolean processSaveSpecialReviewEvent(SaveSpecialReviewEvent<T> saveSpecialReviewEvent) {
        boolean rulePassed = true;
        List specialReviews = saveSpecialReviewEvent.getSpecialReviews();
        boolean validateIrbProtocol = saveSpecialReviewEvent.getValidateIrbProtocol();
        boolean validateIacucProtocol = saveSpecialReviewEvent.getValidateIacucProtocol();
        int i = 0;
        for (SpecialReview specialReview : specialReviews) {
            String errorPath = saveSpecialReviewEvent.getArrayErrorPathPrefix() + "[" + i++ + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            if (validateIrbProtocol && "1".equals(specialReview.getSpecialReviewTypeCode())) {
                rulePassed &= this.validateProtocolNumber(specialReview, specialReviews, HUMAN_SUBJECTS_LINK_TO_IRB_ERROR_STRING);
            } else if (validateIacucProtocol && "2".equals(specialReview.getSpecialReviewTypeCode())) {
                rulePassed &= this.validateProtocolNumber(specialReview, specialReviews, ANIMAL_USAGE_LINK_TO_IACUC_ERROR_STRING);
            } else {
                rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
                rulePassed &= this.validateDateFields(specialReview);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        }
        return rulePassed;
    }

    private boolean validateLinkingDocument(String protocolNumber) {
        Protocol protocol;
        boolean isValid = true;
        if (StringUtils.isNotBlank((String)protocolNumber) && (protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null && !protocol.getProtocolDocument().getPessimisticLocks().isEmpty()) {
            isValid = false;
            this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.locked", new String[]{protocolNumber});
        }
        return isValid;
    }

    private boolean validateProtocolNumber(T specialReview, List<T> specialReviews, String errorString) {
        boolean isValid;
        block6: {
            block8: {
                block7: {
                    isValid = true;
                    if (StringUtils.equals((String)"3", (String)specialReview.getApprovalTypeCode())) break block6;
                    if (!StringUtils.isBlank((String)specialReview.getProtocolNumber())) break block7;
                    isValid = false;
                    this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid", new String[]{PROTOCOL_NUMBER_TITLE, errorString});
                    break block6;
                }
                if (!"1".equals(specialReview.getSpecialReviewTypeCode())) break block8;
                Protocol protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(specialReview.getProtocolNumber());
                if (protocol == null) {
                    isValid = false;
                    this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.invalid", new String[0]);
                } else {
                    List existingSpecialReviews = ListUtils.subtract(specialReviews, Collections.singletonList(specialReview));
                    for (SpecialReview existingSpecialReview : existingSpecialReviews) {
                        if (!StringUtils.equals((String)specialReview.getProtocolNumber(), (String)existingSpecialReview.getProtocolNumber())) continue;
                        isValid = false;
                        this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.duplicate", new String[0]);
                    }
                }
                break block6;
            }
            if (!"2".equals(specialReview.getSpecialReviewTypeCode())) break block6;
            IacucProtocol iacucProtocol = (IacucProtocol)this.getIacucProtocolFinderDao().findCurrentProtocolByNumber(specialReview.getProtocolNumber());
            if (iacucProtocol == null) {
                isValid = false;
                this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.invalid", new String[0]);
            } else {
                List existingSpecialReviews = ListUtils.subtract(specialReviews, Collections.singletonList(specialReview));
                for (SpecialReview existingSpecialReview : existingSpecialReviews) {
                    if (!StringUtils.equals((String)specialReview.getProtocolNumber(), (String)existingSpecialReview.getProtocolNumber())) continue;
                    isValid = false;
                    this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.duplicate", new String[0]);
                }
            }
        }
        return isValid;
    }

    private boolean validateSpecialReviewApprovalFields(T specialReview) {
        boolean isValid = true;
        if (StringUtils.isNotBlank((String)specialReview.getSpecialReviewTypeCode()) && StringUtils.isNotBlank((String)specialReview.getApprovalTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(TYPE_CODE_FIELD, specialReview.getSpecialReviewTypeCode());
            fieldValues.put(APPROVAL_TYPE_CODE_FIELD, specialReview.getApprovalTypeCode());
            Collection validApprovals = this.getBusinessObjectService().findMatching(ValidSpecialReviewApproval.class, fieldValues);
            for (ValidSpecialReviewApproval validApproval : validApprovals) {
                String validApprovalErrorString = this.getValidApprovalErrorString(validApproval);
                isValid &= this.validateApprovalFields(validApproval, specialReview, validApprovalErrorString);
            }
        }
        return isValid;
    }

    private String getValidApprovalErrorString(ValidSpecialReviewApproval approval) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(approval.getSpecialReviewType().getDescription());
        stringBuilder.append("/");
        stringBuilder.append(approval.getSpecialReviewApprovalType().getDescription());
        return stringBuilder.toString();
    }

    private boolean validateApprovalFields(ValidSpecialReviewApproval approval, T specialReview, String errorString) {
        boolean isValid = true;
        if (approval.isProtocolNumberFlag() && StringUtils.isBlank((String)specialReview.getProtocolNumber())) {
            isValid = false;
            this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid", new String[]{PROTOCOL_NUMBER_TITLE, errorString});
        }
        if (approval.isApplicationDateFlag() && specialReview.getApplicationDate() == null) {
            isValid = false;
            this.reportError(APPLICATION_DATE_FIELD, "error.special.review.required.for.valid", new String[]{APPLICATION_DATE_TITLE, errorString});
        }
        if (approval.isApprovalDateFlag() && specialReview.getApprovalDate() == null) {
            isValid = false;
            this.reportError(APPROVAL_DATE_FIELD, "error.special.review.required.for.valid", new String[]{APPROVAL_DATE_TITLE, errorString});
        }
        if (approval.isExemptNumberFlag()) {
            if (CollectionUtils.isEmpty((Collection)specialReview.getExemptionTypeCodes())) {
                isValid = false;
                this.reportError(EXEMPTION_TYPE_CODE_FIELD, "error.special.review.required.for.valid", new String[]{EXEMPTION_TYPE_CODE_TITLE, errorString});
            }
        } else if (!CollectionUtils.isEmpty((Collection)specialReview.getExemptionTypeCodes())) {
            isValid = false;
            this.reportError(EXEMPTION_TYPE_CODE_FIELD, "error.special.review.cannot.select.exemption.for.valid", new String[]{errorString});
        }
        return isValid;
    }

    private boolean validateDateFields(T specialReview) {
        boolean isValid = true;
        isValid &= this.validateDateOrder(specialReview.getApplicationDate(), specialReview.getApprovalDate(), APPROVAL_DATE_FIELD, APPLICATION_DATE_TITLE, APPROVAL_DATE_TITLE);
        isValid &= this.validateDateOrder(specialReview.getApprovalDate(), specialReview.getExpirationDate(), EXPIRATION_DATE_FIELD, APPROVAL_DATE_TITLE, EXPIRATION_DATE_TITLE);
        return isValid &= this.validateDateOrder(specialReview.getApplicationDate(), specialReview.getExpirationDate(), EXPIRATION_DATE_FIELD, APPLICATION_DATE_TITLE, EXPIRATION_DATE_TITLE);
    }

    private boolean validateDateOrder(Date firstDate, Date secondDate, String errorField, String firstDateTitle, String secondDateTitle) {
        boolean isValid = true;
        if (firstDate != null && secondDate != null && secondDate.before(firstDate)) {
            isValid = false;
            this.reportError(errorField, "error.special.review.date.same.or.later", new String[]{secondDateTitle, firstDateTitle});
        }
        return isValid;
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        if (this.protocolFinderDao == null) {
            this.protocolFinderDao = (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
        }
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public IacucProtocolFinderDao getIacucProtocolFinderDao() {
        if (this.iacucProtocolFinderDao == null) {
            this.iacucProtocolFinderDao = (IacucProtocolFinderDao)KraServiceLocator.getService(IacucProtocolFinderDao.class);
        }
        return this.iacucProtocolFinderDao;
    }

    public void setIacucProtocolFinderDao(IacucProtocolFinderDao iacucProtocolFinderDao) {
        this.iacucProtocolFinderDao = iacucProtocolFinderDao;
    }
}

