/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.iacuc.specialreview.IacucProtocolSpecialReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReviewService;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class SpecialReviewHelperBase<T extends SpecialReview<? extends SpecialReviewExemption>>
implements Serializable {
    protected static final String NAMESPACE_CODE = "KC-PROTOCOL";
    protected static final String IACUC_NAMESPACE_CODE = "KC-IACUC";
    protected static final String PARAMETER_CODE = "Document";
    private static final String AMENDMENT_KEY = "A";
    private static final String RENEWAL_KEY = "R";
    private static final long serialVersionUID = 4726816248612555502L;
    private T newSpecialReview;
    private List<String> linkedProtocolNumbers;
    private boolean canModifySpecialReview;
    private boolean isIrbProtocolLinkingEnabled;
    private boolean isIacucProtocolLinkingEnabled;
    private transient ParameterService parameterService;
    private transient ProtocolFinderDao protocolFinderDao;
    private transient SpecialReviewService specialReviewService;
    private transient ProtocolSpecialReviewService protocolSpecialReviewService;
    private transient IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService;

    public T getNewSpecialReview() {
        return (T)this.newSpecialReview;
    }

    public void setNewSpecialReview(T newSpecialReview) {
        this.newSpecialReview = newSpecialReview;
    }

    public List<String> getLinkedProtocolNumbers() {
        return this.linkedProtocolNumbers;
    }

    public void setLinkedProtocolNumbers(List<String> linkedProtocolNumbers) {
        this.linkedProtocolNumbers = linkedProtocolNumbers;
    }

    public boolean getCanModifySpecialReview() {
        return this.canModifySpecialReview;
    }

    public boolean getIsIrbProtocolLinkingEnabled() {
        return this.isIrbProtocolLinkingEnabled;
    }

    public boolean getIsIacucProtocolLinkingEnabled() {
        return this.isIacucProtocolLinkingEnabled;
    }

    public void prepareView() {
        this.initializePermissions();
        this.initializeLinkedProtocolNumbers();
        this.initializeProtocolLinkView();
    }

    public void prepareProtocolLinkViewFields(T specialReview) {
        if (this.getIsIrbProtocolLinkingEnabled() || this.getIsIacucProtocolLinkingEnabled()) {
            if (specialReview != null && "1".equals(specialReview.getSpecialReviewTypeCode())) {
                ProtocolSpecialReviewService protocolSpecialReviewService = this.getProtocolSpecialReviewService();
                protocolSpecialReviewService.populateSpecialReview(specialReview);
            } else if (specialReview != null && "2".equals(specialReview.getSpecialReviewTypeCode())) {
                IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService = this.getIacucProtocolSpecialReviewService();
                iacucProtocolSpecialReviewService.populateSpecialReview(specialReview);
            }
        }
    }

    protected DevelopmentProposal getPropososalDevelopment(String proposalNumber) {
        String PROPOSAL_NUMBER = "PROPOSAL_NUMBER";
        DevelopmentProposal dp = null;
        if (proposalNumber != null) {
            HashMap<String, String> key = new HashMap<String, String>();
            key.put("PROPOSAL_NUMBER", proposalNumber);
            dp = (DevelopmentProposal)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(DevelopmentProposal.class, key);
        }
        return dp;
    }

    protected abstract List<T> getSpecialReviews();

    protected abstract boolean hasModifySpecialReviewPermission(String var1);

    protected abstract boolean isIrbProtocolLinkingEnabledForModule();

    protected abstract boolean isIacucProtocolLinkingEnabledForModule();

    protected Protocol getLastApprovedProtocol(String protocolNumber) {
        String lastApprovedProtocolNumber = protocolNumber;
        if (StringUtils.contains((String)protocolNumber, (String)AMENDMENT_KEY)) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)AMENDMENT_KEY);
        } else if (StringUtils.contains((String)protocolNumber, (String)RENEWAL_KEY)) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)RENEWAL_KEY);
        }
        return this.getProtocolFinderDao().findCurrentProtocolByNumber(lastApprovedProtocolNumber);
    }

    protected void syncProtocolFundingSourcesWithSpecialReviews(String fundingSourceNumber, String fundingSourceTypeCode, String fundingSourceName, String fundingSourceTitle) {
        for (SpecialReview specialReview : this.getSpecialReviews()) {
            if (!"1".equals(specialReview.getSpecialReviewTypeCode())) continue;
            this.prepareProtocolLinkViewFields(specialReview);
            String protocolNumber = specialReview.getProtocolNumber();
            if (this.getSpecialReviewService().isLinkedToProtocolFundingSource(protocolNumber, fundingSourceNumber, fundingSourceTypeCode)) continue;
            this.getSpecialReviewService().addProtocolFundingSourceForSpecialReview(protocolNumber, fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
            this.linkedProtocolNumbers.add(protocolNumber);
        }
        ArrayList<String> deletedLinkedProtocolNumbers = new ArrayList<String>();
        for (String linkedProtocolNumber : this.linkedProtocolNumbers) {
            boolean isLinkedToSpecialReview = false;
            for (SpecialReview specialReview : this.getSpecialReviews()) {
                if (!"1".equals(specialReview.getSpecialReviewTypeCode()) || !StringUtils.equals((String)specialReview.getProtocolNumber(), (String)linkedProtocolNumber)) continue;
                isLinkedToSpecialReview = true;
                break;
            }
            if (isLinkedToSpecialReview) continue;
            this.getSpecialReviewService().deleteProtocolFundingSourceForSpecialReview(linkedProtocolNumber, fundingSourceNumber, fundingSourceTypeCode);
            deletedLinkedProtocolNumbers.add(linkedProtocolNumber);
        }
        this.linkedProtocolNumbers.removeAll(deletedLinkedProtocolNumbers);
    }

    private void initializePermissions() {
        this.canModifySpecialReview = this.hasModifySpecialReviewPermission(this.getUserIdentifier());
        this.isIrbProtocolLinkingEnabled = this.isIrbProtocolLinkingEnabledForModule();
        this.isIacucProtocolLinkingEnabled = this.isIacucProtocolLinkingEnabledForModule();
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    private void initializeLinkedProtocolNumbers() {
        if (this.getIsIrbProtocolLinkingEnabled() || this.getIsIacucProtocolLinkingEnabled()) {
            for (SpecialReview specialReview : this.getSpecialReviews()) {
                if ((!"1".equals(specialReview.getSpecialReviewTypeCode()) || !this.getIsIrbProtocolLinkingEnabled()) && (!"2".equals(specialReview.getSpecialReviewTypeCode()) || !this.getIsIacucProtocolLinkingEnabled())) continue;
                this.linkedProtocolNumbers.add(specialReview.getProtocolNumber());
            }
        }
    }

    private void initializeProtocolLinkView() {
        this.prepareProtocolLinkViewFields(this.getNewSpecialReview());
        for (SpecialReview specialReview : this.getSpecialReviews()) {
            this.prepareProtocolLinkViewFields(specialReview);
        }
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        if (this.protocolFinderDao == null) {
            this.protocolFinderDao = (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
        }
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = (SpecialReviewService)KraServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }

    public ProtocolSpecialReviewService getProtocolSpecialReviewService() {
        if (this.protocolSpecialReviewService == null) {
            this.protocolSpecialReviewService = (ProtocolSpecialReviewService)KraServiceLocator.getService(ProtocolSpecialReviewService.class);
        }
        return this.protocolSpecialReviewService;
    }

    public void setProtocolSpecialReviewService(ProtocolSpecialReviewService protocolSpecialReviewService) {
        this.protocolSpecialReviewService = protocolSpecialReviewService;
    }

    public IacucProtocolSpecialReviewService getIacucProtocolSpecialReviewService() {
        if (this.iacucProtocolSpecialReviewService == null) {
            this.iacucProtocolSpecialReviewService = (IacucProtocolSpecialReviewService)KraServiceLocator.getService(IacucProtocolSpecialReviewService.class);
        }
        return this.iacucProtocolSpecialReviewService;
    }

    public void setIacucProtocolSpecialReviewService(IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService) {
        this.iacucProtocolSpecialReviewService = iacucProtocolSpecialReviewService;
    }

    protected abstract boolean isCanCreateIrbProtocol();

    protected abstract boolean isCanCreateIacucProtocol();
}

