/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.dao.AwardLookupDao;
import org.kuali.kra.dao.VersionHistoryLookupDao;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;

public class AwardLookupDaoOjb
extends LookupDaoOjb
implements AwardLookupDao {
    private VersionHistoryLookupDao versionHistoryLookupDao;

    public List<? extends BusinessObject> getAwardSearchResults(Map fieldValues, boolean usePrimaryKeys) {
        List searchResults = this.getVersionHistoryLookupDao().getSequenceOwnerSearchResults(Award.class, fieldValues, usePrimaryKeys);
        ArrayList<String> activeAwards = new ArrayList<String>();
        ArrayList<Long> awardIds = new ArrayList<Long>();
        for (Object object : searchResults) {
            Award awardSearchBo = (Award)object;
            if (awardSearchBo.getVersionHistory().isActiveVersion()) {
                activeAwards.add(awardSearchBo.getAwardNumber());
                awardIds.add(awardSearchBo.getAwardId());
                continue;
            }
            if (activeAwards.contains(awardSearchBo.getAwardNumber()) || !this.checkAwardHasActiveTnMDocument(awardSearchBo)) continue;
            activeAwards.add(awardSearchBo.getAwardNumber());
            awardIds.add(awardSearchBo.getAwardId());
        }
        if (awardIds.isEmpty()) {
            return new ArrayList();
        }
        Criteria awardCr = new Criteria();
        awardCr.addIn("awardId", awardIds);
        List awardList = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(Award.class, (Criteria)awardCr));
        if (searchResults instanceof CollectionIncomplete) {
            awardList = new CollectionIncomplete((Collection)awardList, ((CollectionIncomplete)searchResults).getActualSizeIfTruncated());
        }
        return awardList;
    }

    private boolean checkAwardHasActiveTnMDocument(Award awardSearckBo) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String[] splitAwardNumber = awardSearckBo.getAwardNumber().split("-");
        StringBuilder rootAwardNumberBuilder = new StringBuilder(12);
        rootAwardNumberBuilder.append(splitAwardNumber[0]);
        rootAwardNumberBuilder.append("-00001");
        String rootAwardNumber = rootAwardNumberBuilder.toString();
        fieldValues.put("rootAwardNumber", rootAwardNumber);
        Criteria tnmCriteria = new Criteria();
        tnmCriteria.addEqualTo("rootAwardNumber", (Object)rootAwardNumber);
        QueryByCriteria query = new QueryByCriteria(TimeAndMoneyDocument.class, tnmCriteria);
        query.addOrderBy("documentNumber", true);
        List timeAndMoneyDocuments = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (!timeAndMoneyDocuments.isEmpty()) {
            WorkflowDocument tnmWorkFlowDoc;
            TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyDocuments.get(0);
            DocumentHeader documentHeader = timeAndMoneyDocument.getDocumentHeader();
            WorkflowDocument workflowDocument = tnmWorkFlowDoc = documentHeader == null || !documentHeader.hasWorkflowDocument() ? null : documentHeader.getWorkflowDocument();
            if (tnmWorkFlowDoc != null && tnmWorkFlowDoc.isFinal()) {
                return true;
            }
        }
        return false;
    }

    public VersionHistoryLookupDao getVersionHistoryLookupDao() {
        return this.versionHistoryLookupDao;
    }

    public void setVersionHistoryLookupDao(VersionHistoryLookupDao versionHistoryLookupDao) {
        this.versionHistoryLookupDao = versionHistoryLookupDao;
    }
}

