/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.common.printing.CurrentReportBean;
import org.kuali.kra.dao.CurrentReportDao;
import org.kuali.kra.dao.ojb.BaseReportDaoOjb;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.DocumentBase;

public class CurrentReportDaoOjb
extends BaseReportDaoOjb
implements CurrentReportDao {
    private VersionHistoryService versionHistoryService;

    public List<CurrentReportBean> queryForCurrentSupport(String personId) throws WorkflowException {
        ArrayList<CurrentReportBean> data = new ArrayList<CurrentReportBean>();
        for (AwardPerson awardPerson : this.executeCurrentSupportQuery(personId)) {
            this.lazyLoadAward(awardPerson);
            CurrentReportBean bean = this.buildReportBean(awardPerson);
            if (bean == null) continue;
            data.add(bean);
        }
        return data;
    }

    private CurrentReportBean buildReportBean(AwardPerson awardPerson) throws WorkflowException {
        Award award = awardPerson.getAward();
        CurrentReportBean bean = null;
        if (this.shouldDataBeIncluded((DocumentBase)award.getAwardDocument()) && award.isActiveVersion() && ObjectUtils.equals((Object)this.getActiveAwardVersionSequenceNumber(award.getAwardNumber()), (Object)award.getSequenceNumber())) {
            bean = new CurrentReportBean(awardPerson);
        }
        return bean;
    }

    private Collection<AwardPerson> executeCurrentSupportQuery(String personId) {
        return this.getBusinessObjectService().findMatching(AwardPerson.class, Collections.singletonMap("personId", personId));
    }

    private void lazyLoadAward(AwardPerson awardPerson) {
        if (awardPerson.getAward() == null) {
            Map searchParms = ServiceHelper.getInstance().buildCriteriaMap(new String[]{"awardNumber", "sequenceNumber"}, new Object[]{awardPerson.getAwardNumber(), awardPerson.getSequenceNumber()});
            Award award = (Award)this.getBusinessObjectService().findMatching(Award.class, searchParms).iterator().next();
            awardPerson.setAward(award);
        }
    }

    private VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    private Integer getActiveAwardVersionSequenceNumber(String awardNumber) {
        Integer retval = null;
        VersionHistory versionHistory = this.getVersionHistoryService().findActiveVersion(Award.class, awardNumber);
        if (versionHistory != null) {
            retval = versionHistory.getSequenceOwnerSequenceNumber();
        }
        return retval;
    }
}

