/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.dao.RolodexDao;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.springframework.dao.DataIntegrityViolationException;
import org.springmodules.orm.ojb.OjbOperationException;

public class RolodexDaoOjb
extends LookupDaoOjb
implements RolodexDao {
    private static final Log LOG = LogFactory.getLog(RolodexDaoOjb.class);

    public List<? extends BusinessObject> getNonOrganizationalRolodexResults(Map fieldValues, boolean usePrimaryKeys) {
        Collection searchResults = new ArrayList();
        Long matchingResultsCount = null;
        Criteria criteria = this.getNonOrganizationalRolodexCriteria(Rolodex.class, fieldValues, usePrimaryKeys);
        try {
            Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(Rolodex.class);
            if (searchResultsLimit != null) {
                matchingResultsCount = new Long(this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery(Rolodex.class, (Criteria)criteria)));
                LookupUtils.applySearchResultsLimit(Rolodex.class, (Criteria)criteria, (DatabasePlatform)this.getDbPlatform());
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = new Long(0L);
            }
            searchResults = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(Rolodex.class, (Criteria)criteria));
            LOG.info((Object)("Got results " + searchResults));
        }
        catch (OjbOperationException e) {
            throw new RuntimeException("RolodexDaoOjb encountered exception during executeSearch", e);
        }
        catch (DataIntegrityViolationException e) {
            throw new RuntimeException("RolodexDaoOjb encountered exception during executeSearch", e);
        }
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    public Criteria getNonOrganizationalRolodexCriteria(Class businessObjectClass, Map fieldValues, boolean usePrimaryKeys) {
        Criteria retval = usePrimaryKeys ? this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, fieldValues) : this.getCollectionCriteriaFromMap((BusinessObject)this.checkBusinessObjectClass(businessObjectClass), fieldValues);
        retval.addNotNull("firstName");
        retval.addNotNull("lastName");
        retval.addNotEqualTo((Object)"active", (Object)Boolean.FALSE);
        LOG.info((Object)("NonOrganizationalQuery" + retval));
        return retval;
    }

    private PersistableBusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to RolodexDaoOjb findCollectionBySearchHelper... method was null");
        }
        PersistableBusinessObject businessObject = null;
        try {
            businessObject = (PersistableBusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("RolodexDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("RolodexDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }
}

