/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.drools.util;

import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.kuali.kra.drools.brms.FactBean;

public class DroolsRuleHandler {
    private RuleBase rules;

    public DroolsRuleHandler(String ruleFile) {
        this.rules = this.getRuleBase(ruleFile);
    }

    private RuleBase getRuleBase(String rulesFile) {
        try {
            InputStreamReader source = new InputStreamReader(this.getClass().getResourceAsStream("/" + rulesFile));
            PackageBuilderConfiguration pkgBuilderCfg = new PackageBuilderConfiguration(new ClassLoader[]{this.getClass().getClassLoader()});
            JavaDialectConfiguration javaConf = (JavaDialectConfiguration)pkgBuilderCfg.getDialectConfiguration("java");
            javaConf.setCompiler(0);
            PackageBuilder builder = new PackageBuilder(pkgBuilderCfg);
            builder.addPackageFromDrl((Reader)source);
            Package pkg = builder.getPackage();
            this.rules = RuleBaseFactory.newRuleBase();
            this.rules.addPackage(pkg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.rules;
    }

    public <T extends FactBean> void executeRules(T fact) {
        StatefulSession workingMemory = this.rules.newStatefulSession();
        workingMemory.insert(fact);
        workingMemory.fireAllRules();
    }
}

