/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.Cfda.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.CFDA;
import org.kuali.kra.external.Cfda.CfdaDTO;
import org.kuali.kra.external.Cfda.service.CfdaNumberService;
import org.kuali.kra.external.HashMapElement;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class CfdaNumberServiceImpl
implements CfdaNumberService {
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(CfdaNumberServiceImpl.class);

    public List<CfdaDTO> getCfdaNumber(String financialAccountNumber, String financialChartOfAccounts) {
        List awards = this.getAwards(financialAccountNumber, financialChartOfAccounts);
        ArrayList<CfdaDTO> cfdaNumbers = new ArrayList<CfdaDTO>();
        if (ObjectUtils.isNotNull((Object)awards)) {
            for (Award award : awards) {
                CFDA cfda;
                HashMap<String, String> searchCriteria = new HashMap<String, String>();
                searchCriteria.put("cfdaNumber", award.getCfdaNumber());
                if (!ObjectUtils.isNotNull((Object)award.getCfdaNumber()) || !ObjectUtils.isNotNull((Object)(cfda = (CFDA)this.businessObjectService.findByPrimaryKey(CFDA.class, searchCriteria)))) continue;
                CfdaDTO cfdaDTO = this.boToDTO(cfda);
                cfdaDTO.setAwardId(award.getAwardId() + "");
                cfdaNumbers.add(cfdaDTO);
            }
            return cfdaNumbers;
        }
        return null;
    }

    public List<CfdaDTO> lookupCfda(List<HashMapElement> criteria) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        ArrayList cfdaNumbers = new ArrayList();
        if (ObjectUtils.isNull(criteria)) {
            cfdaNumbers = new ArrayList(this.businessObjectService.findAll(CFDA.class));
        } else {
            for (HashMapElement element : criteria) {
                searchCriteria.put(element.getKey(), element.getValue());
            }
            cfdaNumbers = new ArrayList(this.businessObjectService.findMatching(CFDA.class, searchCriteria));
        }
        ArrayList<CfdaDTO> cfdaDTOs = new ArrayList<CfdaDTO>();
        for (CFDA cfda : cfdaNumbers) {
            cfdaDTOs.add(this.boToDTO(cfda));
        }
        return cfdaDTOs;
    }

    protected CfdaDTO boToDTO(CFDA cfda) {
        CfdaDTO cfdaDTO = new CfdaDTO();
        cfdaDTO.setCfdaMaintenanceTypeId(cfda.getCfdaMaintenanceTypeId());
        cfdaDTO.setCfdaNumber(cfda.getCfdaNumber());
        cfdaDTO.setCfdaProgramTitleName(cfda.getCfdaProgramTitleName());
        cfdaDTO.setActive(cfda.getActive().booleanValue());
        return cfdaDTO;
    }

    protected List<Award> getAwards(String financialAccountNumber, String chartOfAccounts) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("accountNumber", financialAccountNumber);
        searchCriteria.put("financialChartOfAccountsCode", chartOfAccounts);
        ArrayList<Award> awards = new ArrayList<Award>(this.businessObjectService.findMatching(Award.class, searchCriteria));
        if (ObjectUtils.isNotNull(awards) && !awards.isEmpty()) {
            return awards;
        }
        LOG.warn((Object)("No award found for the account number " + financialAccountNumber + " and chart " + "chartOfAccounts"));
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

