/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.Cfda.service.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.kuali.kra.award.home.CFDA;
import org.kuali.kra.external.Cfda.CfdaService;
import org.kuali.kra.external.Cfda.CfdaUpdateResults;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class CfdaServiceImpl
implements CfdaService {
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private static final String FTP_PREFIX = "ftp://";
    private String cfdaFileName;
    private String govURL;
    private DocumentService documentService;
    private static final Log LOG = LogFactory.getLog(CfdaServiceImpl.class);
    protected static Comparator cfdaComparator = new /* Unavailable Anonymous Inner Class!! */;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, CFDA> retrieveGovCodes() throws IOException {
        TreeMap<String, CFDA> govMap;
        block5: {
            govMap = new TreeMap<String, CFDA>();
            this.createGovURL();
            LOG.info((Object)("Getting government file: " + this.cfdaFileName + " from URL " + this.govURL + " for update"));
            InputStream inputStream = null;
            FTPClient ftp = this.connect(this.getGovURL());
            try {
                inputStream = ftp.retrieveFileStream(this.cfdaFileName);
                if (inputStream != null) {
                    LOG.info((Object)"reading input stream");
                    InputStreamReader screenReader = new InputStreamReader(inputStream);
                    CSVReader csvReader = new CSVReader((Reader)screenReader, ',', '\"', 1);
                    List lines = csvReader.readAll();
                    for (String[] line : lines) {
                        String title = line[0];
                        String number = line[1];
                        CFDA cfda = new CFDA();
                        cfda.setCfdaNumber(number);
                        cfda.setCfdaProgramTitleName(title);
                        cfda.setCfdaMaintenanceTypeId("AUTOMATIC");
                        govMap.put(number, cfda);
                    }
                    break block5;
                }
                throw new IOException("Input stream is null. The file " + this.cfdaFileName + " could not be retrieved from " + this.govURL);
            }
            finally {
                this.disconnect(ftp);
            }
        }
        return govMap;
    }

    public FTPClient connect(String url) {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this.getGovURL());
            ftp.enterLocalPassiveMode();
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                LOG.error((Object)"FTP connection to server not established.");
                throw new IOException("FTP connection to server not established.");
            }
            boolean loggedIn = ftp.login("anonymous", "");
            LOG.info((Object)"Logged in as anonymous");
            if (!loggedIn) {
                LOG.error((Object)"Could not login as anonymous.");
                throw new IOException("Could not login as anonymous.");
            }
        }
        catch (IOException io) {
            LOG.error((Object)io.getMessage());
        }
        return ftp;
    }

    public void disconnect(FTPClient ftp) throws IOException {
        ftp.logout();
        if (ftp.isConnected()) {
            ftp.disconnect();
        }
    }

    protected void createGovURL() {
        String url = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "CFDA_GOV_URL");
        String fileName = StringUtils.substringAfterLast((String)url, (String)"/");
        if (StringUtils.contains((String)(url = StringUtils.substringBeforeLast((String)url, (String)"/")), (String)FTP_PREFIX)) {
            url = StringUtils.remove((String)url, (String)FTP_PREFIX);
        }
        Calendar calendar = this.dateTimeService.getCurrentCalendar();
        String year = "" + calendar.get(1);
        year = year.substring(2, 4);
        fileName = fileName + year;
        fileName = fileName + String.format("%03d", calendar.get(6) - 1);
        fileName = fileName + ".csv";
        this.setGovURL(url);
        this.setCfdaFileName(fileName);
    }

    protected String getGovURL() {
        return this.govURL;
    }

    protected String getCfdaFileName() {
        return this.cfdaFileName;
    }

    protected void setGovURL(String url) {
        this.govURL = url;
    }

    protected void setCfdaFileName(String fileName) {
        this.cfdaFileName = fileName;
    }

    public CfdaUpdateResults updateCfda() {
        SortedMap govCfdaMap;
        CfdaUpdateResults updateResults = new CfdaUpdateResults();
        StringBuilder message = new StringBuilder();
        try {
            govCfdaMap = this.retrieveGovCodes();
        }
        catch (IOException ioe) {
            message.append("Problem encountered while retrieving cfda numbers, the database was not updated." + ioe.getMessage());
            updateResults.setMessage(message.toString());
            return updateResults;
        }
        SortedMap kcMap = this.getCfdaValuesInDatabase();
        updateResults.setNumberOfRecordsInKcDatabase(kcMap.size());
        updateResults.setNumberOfRecordsRetrievedFromWebSite(govCfdaMap.size());
        for (String key : kcMap.keySet()) {
            CFDA kcCfda = (CFDA)kcMap.get(key);
            CFDA govCfda = (CFDA)govCfdaMap.get(key);
            if (kcCfda.getCfdaMaintenanceTypeId().equalsIgnoreCase("MANUAL")) {
                updateResults.setNumberOfRecordsNotUpdatedBecauseManual(1 + updateResults.getNumberOfRecordsNotUpdatedBecauseManual());
            } else if (kcCfda.getCfdaMaintenanceTypeId().equalsIgnoreCase("AUTOMATIC")) {
                if (govCfda == null) {
                    if (kcCfda.getActive().booleanValue()) {
                        kcCfda.setActive(Boolean.valueOf(false));
                        this.businessObjectService.save((PersistableBusinessObject)kcCfda);
                        updateResults.setNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite(updateResults.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + 1);
                    } else {
                        updateResults.setNumberOfRecordsNotUpdatedForHistoricalPurposes(updateResults.getNumberOfRecordsNotUpdatedForHistoricalPurposes() + 1);
                    }
                } else {
                    if (kcCfda.getActive().booleanValue()) {
                        updateResults.setNumberOfRecordsUpdatedBecauseAutomatic(updateResults.getNumberOfRecordsUpdatedBecauseAutomatic() + 1);
                    } else {
                        kcCfda.setActive(Boolean.valueOf(true));
                        updateResults.setNumberOfRecordsReActivated(updateResults.getNumberOfRecordsReActivated() + 1);
                    }
                    kcCfda.setCfdaProgramTitleName(govCfda.getCfdaProgramTitleName());
                    this.businessObjectService.save((PersistableBusinessObject)kcCfda);
                }
            }
            govCfdaMap.remove(key);
        }
        updateResults.setMessage(message.toString());
        this.addNew((Map)govCfdaMap);
        updateResults.setNumberOfRecordsNewlyAddedFromWebSite(govCfdaMap.size() + 1);
        return updateResults;
    }

    protected SortedMap<String, CFDA> getCfdaValuesInDatabase() {
        Collection cfdaValues = this.getBusinessObjectService().findAll(CFDA.class);
        TreeMap<String, CFDA> mapDatabaseCfda = new TreeMap<String, CFDA>(cfdaComparator);
        for (CFDA o : cfdaValues) {
            mapDatabaseCfda.put(o.getCfdaNumber(), o);
        }
        return mapDatabaseCfda;
    }

    protected void addNew(Map<String, CFDA> newCfdas) {
        for (String cfdaKey : newCfdas.keySet()) {
            CFDA cfda = newCfdas.get(cfdaKey);
            String cfdaProgramTitleName = this.trimProgramTitleName(cfda.getCfdaProgramTitleName());
            cfda.setCfdaProgramTitleName(SQLUtils.cleanString((String)cfdaProgramTitleName));
            cfda.setActive(Boolean.valueOf(true));
            cfda.setCfdaMaintenanceTypeId("AUTOMATIC");
            this.getBusinessObjectService().save((PersistableBusinessObject)cfda);
        }
    }

    protected String trimProgramTitleName(String programTitleName) {
        if (programTitleName != null && programTitleName.length() > 300) {
            programTitleName = programTitleName.substring(0, 300);
        }
        return programTitleName;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }
}

