/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.integration.cg.dto.AccountCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.AccountParametersDTO;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.external.award.AccountCreationClient;
import org.kuali.kra.external.award.FinancialIndirectCostRecoveryTypeCode;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class AccountCreationClientBase
implements AccountCreationClient {
    protected static final String SOAP_SERVICE_NAME = "accountCreationServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "accountCreationServiceSOAP");
    private static final String ERROR_MESSAGE = "Cannot connect to the service. The service may be down, please try again later.";
    private static final Log LOG = LogFactory.getLog(AccountCreationClientBase.class);
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;

    protected abstract AccountCreationService getServiceHandle();

    public String isValidAccountNumber(String accountNumber) {
        boolean isValidAccountNumber = false;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info((Object)"Connecting to financial system...");
            isValidAccountNumber = port.isValidAccount(accountNumber);
        }
        catch (Exception e) {
            LOG.error((Object)(ERROR_MESSAGE + e.getMessage()), (Throwable)e);
            return null;
        }
        return isValidAccountNumber + "";
    }

    public String isValidChartAccount(String chartOfAccountsCode, String accountNumber) {
        boolean isValidChartOfAccountsCode = false;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info((Object)"Connecting to financial system...");
            isValidChartOfAccountsCode = port.isValidChartAccount(chartOfAccountsCode, accountNumber);
        }
        catch (Exception e) {
            LOG.error((Object)(ERROR_MESSAGE + e.getMessage()), (Throwable)e);
            return null;
        }
        return isValidChartOfAccountsCode + "";
    }

    public void createAwardAccount(Award award) throws DatatypeConfigurationException, WorkflowException {
        AccountParametersDTO accountParameters = this.getAccountParameters(award);
        AccountCreationStatusDTO createAccountResult = null;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info((Object)"Connecting to financial system...");
            createAccountResult = port.createAccount(accountParameters);
        }
        catch (Exception e) {
            LOG.error((Object)(ERROR_MESSAGE + e.getMessage()), (Throwable)e);
            GlobalVariables.getMessageMap().putError("error.award.createAccount.cannotConnect", "error.award.createAccount.cannotConnect", new String[0]);
        }
        if (createAccountResult != null) {
            if (!StringUtils.equalsIgnoreCase((String)createAccountResult.getStatus(), (String)"success")) {
                String completeErrorMessage = "";
                List errorMessages = createAccountResult.getErrorMessages();
                for (String errorMessage : errorMessages) {
                    completeErrorMessage = completeErrorMessage + errorMessage;
                }
                GlobalVariables.getMessageMap().putError("error.award.createAccount.serviceErrors", "error.award.createAccount.serviceErrors", new String[]{completeErrorMessage});
            } else {
                String financialAccountDocumentNumber = createAccountResult.getDocumentNumber();
                if (financialAccountDocumentNumber == null) {
                    GlobalVariables.getMessageMap().putError("error.award.createAccount.nullDocumentNumber", "error.award.createAccount.nullDocumentNumber", new String[0]);
                    LOG.warn((Object)"Document number returned from KFS account creation service is null.");
                } else {
                    String accountNumber = award.getAccountNumber().toUpperCase();
                    award.setAccountNumber(accountNumber);
                    award.setFinancialAccountDocumentNumber(financialAccountDocumentNumber);
                    Calendar calendar = Calendar.getInstance();
                    award.setFinancialAccountCreationDate(new Date(calendar.getTime().getTime()));
                    award.setFinancialChartOfAccountsCode(createAccountResult.getChartOfAccountsCode());
                    AwardDocument awardDocument = award.getAwardDocument();
                    this.documentService.saveDocument((Document)awardDocument);
                }
                if (ObjectUtils.isNotNull((Object)createAccountResult.getErrorMessages()) && !createAccountResult.getErrorMessages().isEmpty()) {
                    String completeErrorMessage = "";
                    List errorMessages = createAccountResult.getErrorMessages();
                    for (String errorMessage : errorMessages) {
                        completeErrorMessage = completeErrorMessage + errorMessage;
                    }
                    GlobalVariables.getMessageMap().putError("error.award.createAccount.saved.with.errors", "error.award.createAccount.saved.with.errors", new String[]{completeErrorMessage});
                }
            }
        }
    }

    protected AccountParametersDTO getAccountParameters(Award award) throws DatatypeConfigurationException {
        AccountParametersDTO accountParameters = new AccountParametersDTO();
        this.setName(award, accountParameters);
        accountParameters.setAccountNumber(award.getAccountNumber());
        this.setDefaultAddress(award, accountParameters);
        this.setAdminAddress(award, accountParameters);
        String cfdaNumber = award.getCfdaNumber();
        if (cfdaNumber != null) {
            accountParameters.setCfdaNumber(cfdaNumber);
        }
        Date effectiveDate = award.getAwardEffectiveDate();
        GregorianCalendar dateEffective = new GregorianCalendar();
        dateEffective.setTime(effectiveDate);
        XMLGregorianCalendar gregorianDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateEffective);
        accountParameters.setEffectiveDate(gregorianDate);
        Date expirationDate = award.getProjectEndDate();
        GregorianCalendar dateExpiration = new GregorianCalendar();
        dateExpiration.setTime(expirationDate);
        gregorianDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateExpiration);
        accountParameters.setExpirationDate(gregorianDate);
        String expenseGuidelineText = award.getAwardNumber();
        accountParameters.setExpenseGuidelineText(expenseGuidelineText);
        this.setIncomeGuidelineText(award, accountParameters);
        accountParameters.setPurposeText(award.getTitle());
        accountParameters.setUnit(award.getUnitNumber());
        accountParameters.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        AwardFandaRate currentFandaRate = award.getCurrentFandaRate();
        String rateClassCode = currentFandaRate.getFandaRateType().getRateClassCode();
        String rateTypeCode = currentFandaRate.getFandaRateType().getRateTypeCode();
        String icrTypeCode = this.getIndirectCostTypeCode(rateClassCode, rateTypeCode);
        accountParameters.setOffCampusIndicator(currentFandaRate.getOnOffCampusFlag() == false);
        String icrRateCode = award.getIcrRateCode();
        if ("ICRNONE".equals(icrRateCode)) {
            accountParameters.setIndirectCostRate("");
        } else {
            accountParameters.setIndirectCostRate(icrRateCode);
        }
        accountParameters.setIndirectCostTypeCode(icrTypeCode + "");
        accountParameters.setHigherEdFunctionCode(award.getActivityType().getHigherEducationFunctionCode());
        return accountParameters;
    }

    protected String getIndirectCostTypeCode(String rateClassCode, String rateTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("rateClassCode", rateClassCode);
        criteria.put("rateTypeCode", rateTypeCode);
        FinancialIndirectCostRecoveryTypeCode icrCostTypeCode = (FinancialIndirectCostRecoveryTypeCode)this.businessObjectService.findByPrimaryKey(FinancialIndirectCostRecoveryTypeCode.class, criteria);
        return ObjectUtils.isNotNull((Object)icrCostTypeCode) ? icrCostTypeCode.getIcrTypeCode() : "";
    }

    protected void setName(Award award, AccountParametersDTO accountParameters) {
        int ACCOUNT_NAME_LENGTH = 40;
        String accountName = "";
        if (ObjectUtils.isNotNull((Object)award.getSponsor().getAcronym())) {
            accountName = accountName + award.getSponsor().getAcronym() + "-";
        }
        if (ObjectUtils.isNotNull((Object)award.getSponsorAwardNumber())) {
            accountName = accountName + award.getSponsorAwardNumber() + "-";
        }
        if (ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator()) && ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator().getPerson())) {
            accountName = accountName + award.getPrincipalInvestigator().getPerson().getLastName() + award.getPrincipalInvestigator().getPerson().getFirstName();
        }
        if (ObjectUtils.isNotNull((Object)accountName) && accountName.length() > 40) {
            accountName = accountName.substring(0, 39);
        }
        accountParameters.setAccountName(accountName);
    }

    protected void setDefaultAddress(Award award, AccountParametersDTO accountParameters) {
        KcPerson principalInvestigator = award.getPrincipalInvestigator().getPerson();
        if (ObjectUtils.isNotNull((Object)principalInvestigator)) {
            String streetAddress = "";
            if (principalInvestigator.getAddressLine1() != null) {
                streetAddress = streetAddress + principalInvestigator.getAddressLine1();
            }
            if (principalInvestigator.getAddressLine2() != null) {
                streetAddress = streetAddress + principalInvestigator.getAddressLine2();
            }
            if (principalInvestigator.getAddressLine3() != null) {
                streetAddress = streetAddress + principalInvestigator.getAddressLine3();
            }
            accountParameters.setDefaultAddressStreetAddress(streetAddress);
            accountParameters.setDefaultAddressCityName(principalInvestigator.getCity());
            accountParameters.setDefaultAddressStateCode(principalInvestigator.getState());
            accountParameters.setDefaultAddressZipCode(principalInvestigator.getPostalCode());
        }
    }

    protected void setAdminAddress(Award award, AccountParametersDTO accountParameters) {
        List unitContacts = award.getAwardUnitContacts();
        for (AwardUnitContact contact : unitContacts) {
            KcPerson adminPerson;
            contact.refreshReferenceObject("unitAdministratorType");
            UnitAdministratorType adminType = contact.getUnitAdministratorType();
            if (!ObjectUtils.isNotNull((Object)adminType) || !"Administrative Contact".equals(adminType.getDescription()) || !ObjectUtils.isNotNull((Object)(adminPerson = contact.getPerson()))) continue;
            String adminStreetAddress = "";
            if (adminPerson.getAddressLine1() != null) {
                adminStreetAddress = adminStreetAddress + adminPerson.getAddressLine1();
            }
            if (adminPerson.getAddressLine2() != null) {
                adminStreetAddress = adminStreetAddress + adminPerson.getAddressLine2();
            }
            if (adminPerson.getAddressLine3() != null) {
                adminStreetAddress = adminStreetAddress + adminPerson.getAddressLine3();
            }
            accountParameters.setAdminContactAddressStreetAddress(adminStreetAddress);
            accountParameters.setAdminContactAddressStreetAddress(adminPerson.getAddressLine1());
            accountParameters.setAdminContactAddressCityName(adminPerson.getCity());
            accountParameters.setAdminContactAddressStateCode(adminPerson.getState());
            accountParameters.setAdminContactAddressZipCode(adminPerson.getPostalCode());
        }
    }

    protected void setIncomeGuidelineText(Award award, AccountParametersDTO accountParameters) {
        award.refreshReferenceObject("awardBasisOfPayment");
        String paymentBasis = award.getAwardBasisOfPayment().getDescription();
        award.refreshReferenceObject("awardMethodOfPayment");
        String paymentMethod = award.getAwardMethodOfPayment().getDescription();
        String incomeGuidelineText = "";
        if (paymentBasis != null) {
            incomeGuidelineText = incomeGuidelineText + paymentBasis;
        }
        if (paymentMethod != null) {
            incomeGuidelineText = incomeGuidelineText + " " + paymentMethod;
        }
        accountParameters.setIncomeGuidelineText(incomeGuidelineText);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

