/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardAccountServiceImpl
implements AwardAccountService {
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(AwardAccountServiceImpl.class);
    private ParameterService parameterService;

    public List<AwardAccountDTO> getAwardAccounts(String financialAccountNumber, String chartOfAccounts) {
        if (ObjectUtils.isNull((Object)financialAccountNumber) || ObjectUtils.isNull((Object)chartOfAccounts)) {
            LOG.warn((Object)"One or both of the criteria sent was null.");
            return null;
        }
        List awards = this.getAwards(financialAccountNumber, chartOfAccounts);
        return this.getAwardAccountDTOs(awards);
    }

    protected List<AwardAccountDTO> getAwardAccountDTOs(List<Award> awards) {
        ArrayList<AwardAccountDTO> awardDTOs = new ArrayList<AwardAccountDTO>();
        if (ObjectUtils.isNotNull(awards)) {
            for (Award award : awards) {
                AwardAccountDTO awardAccountDTO = new AwardAccountDTO();
                awardAccountDTO.setProposalFederalPassThroughAgencyNumber(award.getSponsorCode());
                awardAccountDTO.setGrantNumber(award.getSponsorAwardNumber());
                awardAccountDTO.setInstitutionalproposalId(this.getProposalId(award));
                awardAccountDTO.setAwardId(award.getAwardId());
                if (ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator())) {
                    awardAccountDTO.setProjectDirector(award.getPrincipalInvestigator().getPersonId());
                } else {
                    awardAccountDTO.setProjectDirector(null);
                }
                awardAccountDTO.setProposalNumber(award.getAwardNumber());
                awardAccountDTO.setSponsorCode(award.getSponsorCode());
                awardAccountDTO.setSponsorName(award.getSponsorName());
                awardAccountDTO.setFederalSponsor(this.isFederalSponsor(award));
                awardAccountDTO.setAwardTitle(award.getTitle());
                awardAccountDTO.setPrimeSponsorCode(award.getPrimeSponsorCode());
                if (ObjectUtils.isNotNull((Object)award.getPrimeSponsor())) {
                    awardAccountDTO.setPrimeSponsorName(award.getPrimeSponsor().getSponsorName());
                    awardAccountDTO.setPrimeSponsorTypeCode(award.getPrimeSponsor().getSponsorTypeCode());
                } else {
                    awardAccountDTO.setPrimeSponsorTypeCode(null);
                    awardAccountDTO.setPrimeSponsorName(null);
                }
                if (ObjectUtils.isNotNull((Object)award.getSponsor())) {
                    awardAccountDTO.setSponsorTypeCode(award.getSponsor().getSponsorTypeCode());
                } else {
                    awardAccountDTO.setSponsorTypeCode(null);
                }
                awardDTOs.add(awardAccountDTO);
            }
        }
        return awardDTOs;
    }

    protected Long getProposalId(Award award) {
        String proposalNumber = award.getProposalNumber();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("proposalNumber", proposalNumber);
        ArrayList proposals = new ArrayList(this.businessObjectService.findMatching(InstitutionalProposal.class, searchCriteria));
        if (ObjectUtils.isNotNull(proposals)) {
            return proposals.isEmpty() ? null : ((InstitutionalProposal)proposals.get(0)).getProposalId();
        }
        return null;
    }

    protected boolean isFederalSponsor(Award award) {
        String federalSponsorTypeCode = this.parameterService.getParameterValueAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE");
        return this.isSponsorTypeFederal(award, federalSponsorTypeCode) || this.isPrimeSponsorFederal(award, federalSponsorTypeCode);
    }

    protected boolean isPrimeSponsorFederal(Award award, String federalSponsorTypeCode) {
        return ObjectUtils.isNotNull((Object)award.getPrimeSponsor()) && ObjectUtils.isNotNull((Object)award.getPrimeSponsor().getSponsorType()) && award.getPrimeSponsor().getSponsorType().getSponsorTypeCode().equals(federalSponsorTypeCode);
    }

    protected boolean isSponsorTypeFederal(Award award, String federalSponsorTypeCode) {
        return ObjectUtils.isNotNull((Object)award.getSponsor()) && ObjectUtils.isNotNull((Object)award.getSponsor().getSponsorTypeCode()) && award.getSponsor().getSponsorTypeCode().equals(federalSponsorTypeCode);
    }

    protected List<Award> getAwards(String financialAccountNumber, String chartOfAccounts) {
        ArrayList<Object> awards = new ArrayList<Award>();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)financialAccountNumber)) {
            searchCriteria.put("accountNumber", financialAccountNumber);
            searchCriteria.put("financialChartOfAccountsCode", chartOfAccounts);
            searchCriteria.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
            awards = new ArrayList(this.businessObjectService.findMatching(Award.class, searchCriteria));
        }
        if (ObjectUtils.isNull(awards) || awards.isEmpty()) {
            LOG.warn((Object)("No award found for the account number " + financialAccountNumber + " and chart " + "chartOfAccounts"));
        }
        return awards;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

