/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.external.award.AwardAccountValidationService;
import org.kuali.kra.external.award.FinancialIndirectCostRecoveryTypeCode;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardAccountValidationServiceImpl
implements AwardAccountValidationService {
    private static final String AWARD_EFFECTIVE_DATE_NOT_SPECIFIED = "error.award.createAccount.invalid.effectiveDate";
    private static final String AWARD_ID_NOT_SPECIFIED = "error.award.createAccount.invalid.awardId";
    private static final String AWARD_END_DATE_NOT_SPECIFIED = "error.award.createAccount.invalid.endDate";
    private static final String AWARD_ACTIVITY_TYPE_CODE = "error.award.createAccount.invalid.activityTypeCode";
    private static final String AWARD_PAYMENT_BASIS_NOT_SPECIFIED = "error.award.createAccount.invalid.paymentBasis";
    private static final String AWARD_PAYMENT_METHOD_NOT_SPECIFIED = "error.award.createAccount.invalid.paymentMethod";
    private static final String AWARD_ADDRESS_NOT_COMPLETE = "error.award.createAccount.invalid.piAddress";
    private static final String AWARD_PI_NOT_SPECIFIED = "error.award.createAccount.invalid.pi";
    private static final String AWARD_F_AND_A_RATE_NOT_SPECIFIED = "error.award.createAccount.invalid.rate";
    private BusinessObjectService businessObjectService;

    public boolean validateAwardAccountDetails(Award award) {
        boolean rulePassed = true;
        rulePassed &= this.isValidEffectiveDate(award);
        rulePassed &= this.isValidExpenseGuidelineText(award);
        rulePassed &= this.isValidExpirationDate(award);
        rulePassed &= this.isValidHigherEducationCode(award);
        rulePassed &= this.isValidPaymentBasis(award);
        rulePassed &= this.isValidPaymentMethod(award);
        rulePassed &= this.isValidAddress(award);
        return rulePassed &= this.isValidFandarate(award);
    }

    protected boolean isValidAddress(Award award) {
        boolean isValid = true;
        if (ObjectUtils.isNull((Object)award.getPrincipalInvestigator())) {
            GlobalVariables.getMessageMap().putError(AWARD_PI_NOT_SPECIFIED, AWARD_PI_NOT_SPECIFIED, new String[0]);
            isValid = false;
        } else {
            KcPerson principalInvestigator = award.getPrincipalInvestigator().getPerson();
            if (ObjectUtils.isNotNull((Object)principalInvestigator)) {
                String streetAddress = principalInvestigator.getAddressLine1();
                String cityName = principalInvestigator.getCity();
                String stateCode = principalInvestigator.getState();
                String postalCode = principalInvestigator.getPostalCode();
                if (StringUtils.isBlank((String)streetAddress) || StringUtils.isBlank((String)cityName) || StringUtils.isBlank((String)stateCode) || StringUtils.isBlank((String)postalCode)) {
                    GlobalVariables.getMessageMap().putError(AWARD_ADDRESS_NOT_COMPLETE, AWARD_ADDRESS_NOT_COMPLETE, new String[0]);
                    isValid = false;
                }
            } else {
                GlobalVariables.getMessageMap().putError(AWARD_ADDRESS_NOT_COMPLETE, AWARD_ADDRESS_NOT_COMPLETE, new String[0]);
                isValid = false;
            }
        }
        return isValid;
    }

    protected boolean isValidFandarate(Award award) {
        List rates = award.getAwardFandaRate();
        boolean isValid = true;
        if (ObjectUtils.isNull((Object)rates) || rates.size() == 0) {
            GlobalVariables.getMessageMap().putError(AWARD_F_AND_A_RATE_NOT_SPECIFIED, AWARD_F_AND_A_RATE_NOT_SPECIFIED, new String[0]);
            isValid = false;
        }
        return isValid;
    }

    protected boolean isValidIdcRate(Award award) {
        List rates = award.getAwardFandaRate();
        boolean isValid = true;
        if (ObjectUtils.isNull((Object)rates) || rates.size() == 0) {
            GlobalVariables.getMessageMap().putError(AWARD_F_AND_A_RATE_NOT_SPECIFIED, AWARD_F_AND_A_RATE_NOT_SPECIFIED, new String[0]);
            isValid = false;
        } else {
            for (AwardFandaRate rate : rates) {
                String rateClassCode = rate.getFandaRateType().getRateClassCode();
                String rateTypeCode = rate.getFandaRateType().getRateTypeCode();
                FinancialIndirectCostRecoveryTypeCode icrCostTypeCode = this.getIndirectCostRecoveryTypeCode(rateClassCode, rateTypeCode);
                String icrRateCode = this.getIcrRateCode(rate);
                if (ObjectUtils.isNull((Object)icrCostTypeCode) || StringUtils.isEmpty((String)icrCostTypeCode.getIcrTypeCode())) {
                    String errorParameter = "(" + rateClassCode + ", " + rateTypeCode + ")";
                    GlobalVariables.getMessageMap().putError(AWARD_F_AND_A_RATE_NOT_SPECIFIED, "error.award.createAccount.icr.rate.type.code.empty", new String[]{errorParameter});
                    isValid &= false;
                }
                if (!ObjectUtils.isNull((Object)icrRateCode) && !StringUtils.isEmpty((String)icrRateCode)) continue;
                GlobalVariables.getMessageMap().putError(AWARD_F_AND_A_RATE_NOT_SPECIFIED, "error.award.createAccount.icr.rate.code.empty", new String[]{rate.getApplicableFandaRate() + ""});
            }
        }
        return isValid;
    }

    protected FinancialIndirectCostRecoveryTypeCode getIndirectCostRecoveryTypeCode(String rateClassCode, String rateTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("rateClassCode", rateClassCode);
        criteria.put("rateTypeCode", rateTypeCode);
        FinancialIndirectCostRecoveryTypeCode icrCostTypeCode = (FinancialIndirectCostRecoveryTypeCode)this.businessObjectService.findByPrimaryKey(FinancialIndirectCostRecoveryTypeCode.class, criteria);
        return icrCostTypeCode;
    }

    protected String getIcrRateCode(AwardFandaRate currentFandaRate) {
        String icrRateCode = "";
        HashMap<String, KualiDecimal> criteria = new HashMap<String, KualiDecimal>();
        if (currentFandaRate.getOnCampusFlag().equalsIgnoreCase("N")) {
            criteria.put("onCampusRate", currentFandaRate.getApplicableFandaRate());
        } else {
            criteria.put("offCampusRate", currentFandaRate.getApplicableFandaRate());
        }
        List rates = (List)this.businessObjectService.findMatching(ValidRates.class, criteria);
        if (ObjectUtils.isNotNull((Object)rates) && !rates.isEmpty()) {
            icrRateCode = ((ValidRates)rates.get(0)).getIcrRateCode();
        }
        return icrRateCode;
    }

    protected boolean isValidPaymentBasis(Award award) {
        if (award.getBasisOfPaymentCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_PAYMENT_BASIS_NOT_SPECIFIED, AWARD_PAYMENT_BASIS_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidPaymentMethod(Award award) {
        if (award.getMethodOfPaymentCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_PAYMENT_METHOD_NOT_SPECIFIED, AWARD_PAYMENT_METHOD_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidHigherEducationCode(Award award) {
        if (award.getActivityTypeCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_ACTIVITY_TYPE_CODE, AWARD_ACTIVITY_TYPE_CODE, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidEffectiveDate(Award award) {
        if (award.getAwardEffectiveDate() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_EFFECTIVE_DATE_NOT_SPECIFIED, AWARD_EFFECTIVE_DATE_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidExpenseGuidelineText(Award award) {
        if (award.getAwardId() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_ID_NOT_SPECIFIED, AWARD_ID_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidExpirationDate(Award award) {
        if (award.getProjectEndDate() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_END_DATE_NOT_SPECIFIED, AWARD_END_DATE_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

