/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.Operator;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.external.budget.BudgetAdjustmentServiceHelper;
import org.kuali.kra.external.budget.RateClassRateType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetAdjustmentServiceHelperImpl
implements BudgetAdjustmentServiceHelper {
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(BudgetAdjustmentServiceHelperImpl.class);

    public HashMap<String, BudgetDecimal> getNonPersonnelCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        HashMap netCost = new HashMap();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        List currentLineItems = ((BudgetPeriod)currentBudget.getBudgetPeriods().get(period)).getBudgetLineItems();
        HashMap<String, BudgetDecimal> currentLineItemCosts = new HashMap<String, BudgetDecimal>();
        for (BudgetLineItem currentLineItem : currentLineItems) {
            if (StringUtils.equalsIgnoreCase((String)currentLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (String)"P")) continue;
            currentLineItemCosts.put(currentLineItem.getCostElement(), currentLineItem.getLineItemCost());
        }
        return currentLineItemCosts;
    }

    public SortedMap<RateType, BudgetDecimal> getNonPersonnelCalculatedDirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        SortedMap currentNonPersonnelCalcDirectCost = currentBudget.getNonPersonnelCalculatedExpenseTotals();
        TreeMap<RateType, BudgetDecimal> netNonPersonnelCalculatedDirectCost = new TreeMap<RateType, BudgetDecimal>();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        for (RateType rateType : currentNonPersonnelCalcDirectCost.keySet()) {
            List currentExpenses = (List)currentNonPersonnelCalcDirectCost.get(rateType);
            netNonPersonnelCalculatedDirectCost.put(rateType, (BudgetDecimal)currentExpenses.get(period));
        }
        return netNonPersonnelCalculatedDirectCost;
    }

    public Map<RateClassRateType, BudgetDecimal> getIndirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        int period = currentBudget.getBudgetPeriods().size() - 1;
        List currentLineItems = ((BudgetPeriod)currentBudget.getBudgetPeriods().get(period)).getBudgetLineItems();
        HashMap<RateClassRateType, Object> currentIndirectTotals = new HashMap<RateClassRateType, Object>();
        for (BudgetLineItem lineItem : currentLineItems) {
            for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                if (!lineItemCalculatedAmount.getRateClass().getRateClassType().equalsIgnoreCase("O")) continue;
                RateClassRateType currentKey = new RateClassRateType(lineItemCalculatedAmount.getRateClassCode(), lineItemCalculatedAmount.getRateTypeCode());
                if (currentIndirectTotals.containsKey(currentKey)) {
                    currentIndirectTotals.put(currentKey, ((BudgetDecimal)currentIndirectTotals.get(currentKey)).add((AbstractKualiDecimal)lineItemCalculatedAmount.getCalculatedCost()));
                    continue;
                }
                currentIndirectTotals.put(currentKey, lineItemCalculatedAmount.getCalculatedCost());
            }
        }
        HashMap<RateClassRateType, BudgetDecimal> netIndirectTotals = new HashMap<RateClassRateType, BudgetDecimal>();
        for (RateClassRateType rate : currentIndirectTotals.keySet()) {
            netIndirectTotals.put(rate, (BudgetDecimal)currentIndirectTotals.get(rate));
        }
        return netIndirectTotals;
    }

    public Map<RateClassRateType, BudgetDecimal> getPersonnelCalculatedDirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        SortedMap currentTotals = currentBudget.getPersonnelCalculatedExpenseTotals();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        HashMap currentCost = new HashMap();
        HashMap<RateClassRateType, BudgetDecimal> netCost = new HashMap<RateClassRateType, BudgetDecimal>();
        for (RateType rate : currentTotals.keySet()) {
            if (StringUtils.equalsIgnoreCase((String)rate.getRateClass().getRateClassType(), (String)"O")) continue;
            LOG.info((Object)("Rate Class: " + rate.getRateClassCode() + "RateType: " + rate.getRateTypeCode() + ""));
            currentCost.put(new RateClassRateType(rate.getRateClassCode(), rate.getRateTypeCode()), ((List)currentTotals.get(rate)).get(period));
        }
        for (RateType rate : currentCost.keySet()) {
            netCost.put((RateClassRateType)rate, (BudgetDecimal)currentCost.get(rate));
        }
        return netCost;
    }

    public Map<RateClassRateType, BudgetDecimal> getPersonnelFringeCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        BudgetCategoryType personnelCategory = this.getPersonnelCategoryType();
        List currentPersonnelObjectCodes = (List)currentBudget.getObjectCodeListByBudgetCategoryType().get(personnelCategory);
        Map currentFringeTotals = this.getFringeTotals(currentPersonnelObjectCodes, currentBudget);
        HashMap<RateClassRateType, BudgetDecimal> netFringeTotals = new HashMap<RateClassRateType, BudgetDecimal>();
        for (RateClassRateType rate : currentFringeTotals.keySet()) {
            netFringeTotals.put(rate, (BudgetDecimal)currentFringeTotals.get(rate));
        }
        return netFringeTotals;
    }

    protected Map<RateClassRateType, BudgetDecimal> getFringeTotals(List<CostElement> currentPersonnelObjectCodes, Budget budget) {
        HashMap<RateClassRateType, BudgetDecimal> fringeTotals = new HashMap<RateClassRateType, BudgetDecimal>();
        if (CollectionUtils.isNotEmpty(currentPersonnelObjectCodes)) {
            for (CostElement personnelCostElement : currentPersonnelObjectCodes) {
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    List filteredLineItems = this.getPersonnelLineItems(budgetPeriod, personnelCostElement);
                    for (BudgetLineItem lineItem : filteredLineItems) {
                        for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                            lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                            if (!lineItemCalculatedAmount.getRateClass().getRateClassType().equalsIgnoreCase("E")) continue;
                            RateClassRateType currentKey = new RateClassRateType(lineItemCalculatedAmount.getRateClassCode(), lineItemCalculatedAmount.getRateTypeCode());
                            if (fringeTotals.containsKey(currentKey)) {
                                fringeTotals.put(currentKey, (BudgetDecimal)((BudgetDecimal)fringeTotals.get(currentKey)).add((AbstractKualiDecimal)lineItemCalculatedAmount.getCalculatedCost()));
                                continue;
                            }
                            fringeTotals.put(currentKey, lineItemCalculatedAmount.getCalculatedCost());
                        }
                    }
                }
            }
        }
        return fringeTotals;
    }

    protected List<BudgetLineItem> getPersonnelLineItems(BudgetPeriod budgetPeriod, CostElement personnelCostElement) {
        QueryList lineItemQueryList = new QueryList();
        lineItemQueryList.addAll((Collection)budgetPeriod.getBudgetLineItems());
        Equals objectCodeEquals = new Equals("costElement", (Comparable)((Object)personnelCostElement.getCostElement()));
        QueryList filteredLineItems = lineItemQueryList.filter((Operator)objectCodeEquals);
        return filteredLineItems;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected BudgetCategoryType getPersonnelCategoryType() {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("budgetCategoryTypeCode", "P");
        return (BudgetCategoryType)this.getBusinessObjectService().findByPrimaryKey(BudgetCategoryType.class, primaryKeys);
    }

    public SortedMap<String, BudgetDecimal> getPersonnelSalaryCost(Budget currentBudget, AwardBudgetExt previousBudget) throws Exception {
        SortedMap currentSalaryTotals = currentBudget.getObjectCodePersonnelSalaryTotals();
        TreeMap<String, BudgetDecimal> netSalary = new TreeMap<String, BudgetDecimal>();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        Iterator i$ = currentSalaryTotals.keySet().iterator();
        while (i$.hasNext()) {
            String person;
            String key = person = (String)i$.next();
            if (person.contains(",")) {
                String[] objectCode = this.getElements(key);
                key = objectCode[0];
            }
            BudgetDecimal currentSalary = (BudgetDecimal)((List)currentSalaryTotals.get(person)).get(period);
            netSalary.put(key, currentSalary);
        }
        return netSalary;
    }

    protected String[] getElements(String person) throws Exception {
        if (person.contains(",")) {
            String[] personElements = person.split(",");
            return personElements;
        }
        LOG.error((Object)"The string is not in the format objectCode,personId  . Unable to retrieve object code.");
        throw new Exception("The string " + person + "is not in the format objectCode,personId  . Unable to retrieve object code.");
    }
}

