/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.external.HashMapElement;
import org.kuali.kra.external.budget.service.BudgetCategoryDTO;
import org.kuali.kra.external.budget.service.BudgetCategoryService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetCategoryServiceImpl
implements BudgetCategoryService {
    private BusinessObjectService businessObjectService;

    public List<BudgetCategoryDTO> lookupBudgetCategories(List<HashMapElement> criteria) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        ArrayList<BudgetCategoryDTO> budgetCategoryDTO = new ArrayList<BudgetCategoryDTO>();
        ArrayList budgetCategories = new ArrayList();
        if (ObjectUtils.isNull(criteria)) {
            budgetCategories = new ArrayList(this.businessObjectService.findAll(BudgetCategory.class));
        } else {
            for (HashMapElement element : criteria) {
                searchCriteria.put(element.getKey(), element.getValue());
            }
            budgetCategories = new ArrayList(this.businessObjectService.findMatching(BudgetCategory.class, searchCriteria));
        }
        return budgetCategoryDTO;
    }

    protected BudgetCategoryDTO budgetCategoryBoToDTO(BudgetCategory budget) {
        BudgetCategoryDTO budgetCategoryDTO = new BudgetCategoryDTO();
        budgetCategoryDTO.setAuthorPersonName(budget.getAuthorPersonName());
        budgetCategoryDTO.setBudgetCategoryCode(budget.getBudgetCategoryCode());
        budgetCategoryDTO.setBudgetCategoryTypeCode(budget.getBudgetCategoryType().getBudgetCategoryTypeCode());
        budgetCategoryDTO.setBudgetCategoryTypeDescription(budget.getBudgetCategoryType().getDescription());
        budgetCategoryDTO.setDescription(budget.getDescription());
        return budgetCategoryDTO;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

