/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.customdata.IacucProtocolCustomDataHelper;
import org.kuali.kra.iacuc.noteattachment.IacucNotesAttachmentsHelper;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.onlinereview.IacucOnlineReviewsActionHelper;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.iacuc.permission.IacucPermissionsHelper;
import org.kuali.kra.iacuc.personnel.IacucPersonnelHelper;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolProceduresHelper;
import org.kuali.kra.iacuc.protocol.IacucProtocolHelper;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReferenceBean;
import org.kuali.kra.iacuc.questionnaire.IacucQuestionnaireHelper;
import org.kuali.kra.iacuc.specialreview.IacucProtocolSpecialReviewHelper;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesHelper;
import org.kuali.kra.iacuc.species.exception.IacucProtocolExceptionHelper;
import org.kuali.kra.iacuc.threers.IacucAlternateSearchHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.customdata.ProtocolCustomDataHelperBase;
import org.kuali.kra.protocol.onlinereview.OnlineReviewsActionHelperBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.protocol.ProtocolHelperBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBeanBase;
import org.kuali.kra.protocol.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewHelperBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolForm
extends ProtocolFormBase {
    private static final long serialVersionUID = -535557943052220820L;
    private IacucProtocolSpeciesHelper iacucProtocolSpeciesHelper;
    private IacucAlternateSearchHelper iacucAlternateSearchHelper;
    private IacucProtocolExceptionHelper iacucProtocolExceptionHelper;
    private IacucProtocolProceduresHelper iacucProtocolProceduresHelper;
    private boolean defaultOpenCopyTab = false;
    private boolean reinitializeModifySubmissionFields = true;

    public IacucProtocolForm() throws Exception {
        this.initializeIacucProtocolSpecies();
        this.initializeIacucAlternateSearchHelper();
        this.initializeIacucProtocolException();
        this.initializeIacucProtocolProcedures();
    }

    public void initializeIacucProtocolSpecies() throws Exception {
        this.setIacucProtocolSpeciesHelper(new IacucProtocolSpeciesHelper(this));
    }

    public void initializeIacucProtocolProcedures() throws Exception {
        this.setIacucProtocolProceduresHelper(new IacucProtocolProceduresHelper(this));
    }

    public void initializeIacucProtocolException() throws Exception {
        this.setIacucProtocolExceptionHelper(new IacucProtocolExceptionHelper(this));
    }

    protected void initializeIacucAlternateSearchHelper() throws Exception {
        this.setIacucAlternateSearchHelper(new IacucAlternateSearchHelper(this));
    }

    public String getActionName() {
        return "iacucProtocol";
    }

    protected String getDefaultDocumentTypeName() {
        return "IacucProtocolDocument";
    }

    public IacucProtocolDocument getIacucProtocolDocument() {
        return (IacucProtocolDocument)super.getProtocolDocument();
    }

    protected String getLockRegion() {
        return "IACUC_PROTOCOL";
    }

    public IacucProtocolHelper getProtocolHelper() {
        return (IacucProtocolHelper)super.getProtocolHelper();
    }

    protected ProtocolHelperBase createNewProtocolHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucProtocolHelper((IacucProtocolForm)protocolForm);
    }

    public IacucPermissionsHelper getPermissionsHelper(ProtocolFormBase protocolForm) {
        return (IacucPermissionsHelper)super.getPermissionsHelper();
    }

    protected IacucPermissionsHelper createNewPermissionsHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucPermissionsHelper((IacucProtocolForm)protocolForm);
    }

    public IacucPersonnelHelper getPersonnelHelper(ProtocolFormBase protocolForm) {
        return (IacucPersonnelHelper)super.getPersonnelHelper();
    }

    protected IacucPersonnelHelper createNewPersonnelHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucPersonnelHelper((ProtocolFormBase)((IacucProtocolForm)protocolForm));
    }

    public IacucNotesAttachmentsHelper getNotesAttachmentHelper(ProtocolFormBase form) {
        return (IacucNotesAttachmentsHelper)super.getNotesAttachmentsHelper();
    }

    protected IacucNotesAttachmentsHelper createNewNotesAttachmentsHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucNotesAttachmentsHelper((ProtocolFormBase)((IacucProtocolForm)protocolForm));
    }

    protected QuestionnaireHelperBase createNewQuestionnaireHelper(ProtocolFormBase form) {
        return new IacucQuestionnaireHelper(form);
    }

    protected IacucActionHelper createNewActionHelper(ProtocolFormBase protocolForm) throws Exception {
        return new IacucActionHelper(protocolForm);
    }

    public String getModuleCode() {
        return "9";
    }

    public IacucProtocolSpeciesHelper getIacucProtocolSpeciesHelper() {
        return this.iacucProtocolSpeciesHelper;
    }

    public void setIacucProtocolSpeciesHelper(IacucProtocolSpeciesHelper iacucProtocolSpeciesHelper) {
        this.iacucProtocolSpeciesHelper = iacucProtocolSpeciesHelper;
    }

    public IacucAlternateSearchHelper getIacucAlternateSearchHelper() {
        return this.iacucAlternateSearchHelper;
    }

    public void setIacucAlternateSearchHelper(IacucAlternateSearchHelper iacucAlternateSearchHelper) {
        this.iacucAlternateSearchHelper = iacucAlternateSearchHelper;
    }

    protected ProtocolReferenceBeanBase createNewProtocolReferenceBeanInstance() {
        return new IacucProtocolReferenceBean();
    }

    public IacucProtocolExceptionHelper getIacucProtocolExceptionHelper() {
        return this.iacucProtocolExceptionHelper;
    }

    public void setIacucProtocolExceptionHelper(IacucProtocolExceptionHelper iacucProtocolExceptionHelper) {
        this.iacucProtocolExceptionHelper = iacucProtocolExceptionHelper;
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).clear();
        }
        this.getIacucProtocolDocument().getIacucProtocol().setIacucProtocolStudyGroupBeans(this.getIacucProtocolProcedureService().getRevisedStudyGroupBeans(this.getIacucProtocolDocument().getIacucProtocol(), this.getIacucProtocolProceduresHelper().getAllProcedures()));
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        IacucProtocolDocument pd = this.getIacucProtocolDocument();
        HeaderField documentNumber = (HeaderField)this.getDocInfo().get(0);
        documentNumber.setDdAttributeEntryName("DataDictionary.IacucProtocolDocument.attributes.documentNumber");
        ProtocolStatusBase protocolStatus = pd == null ? null : pd.getIacucProtocol().getProtocolStatus();
        HeaderField docStatus = new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", protocolStatus == null ? "" : protocolStatus.getDescription());
        this.getDocInfo().set(1, docStatus);
        String lastUpdatedDateStr = null;
        if (pd != null && pd.getUpdateTimestamp() != null) {
            lastUpdatedDateStr = this.getFormattedDateTime(pd.getUpdateTimestamp());
        }
        if (this.getDocInfo().size() > 2) {
            String modifiedInitiatorFieldStr;
            KcPerson initiator = this.getKcPersonService().getKcPersonByPersonId(pd.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
            String string = modifiedInitiatorFieldStr = initiator == null ? "" : initiator.getUserName();
            if (StringUtils.isNotBlank((String)lastUpdatedDateStr)) {
                modifiedInitiatorFieldStr = modifiedInitiatorFieldStr + " : " + lastUpdatedDateStr;
            }
            this.getDocInfo().set(2, new HeaderField("DataDictionary.IacucProtocol.attributes.initiatorLastUpdated", modifiedInitiatorFieldStr));
        }
        String protocolSubmissionStatusStr = null;
        if (pd != null && pd.getIacucProtocol() != null && pd.getIacucProtocol().getProtocolSubmission() != null) {
            pd.getIacucProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            protocolSubmissionStatusStr = pd.getIacucProtocol().getProtocolSubmission().getSubmissionStatus().getDescription();
        }
        HeaderField protocolSubmissionStatus = new HeaderField("DataDictionary.IacucProtocol.attributes.protocolSubmissionStatus", protocolSubmissionStatusStr);
        this.getDocInfo().set(3, protocolSubmissionStatus);
        this.getDocInfo().add(new HeaderField("DataDictionary.IacucProtocol.attributes.protocolNumber", pd == null ? null : pd.getIacucProtocol().getProtocolNumber()));
        String expirationDateStr = null;
        if (pd != null && pd.getProtocol().getExpirationDate() != null) {
            expirationDateStr = this.getFormattedDate(pd.getIacucProtocol().getExpirationDate());
        }
        HeaderField expirationDate = new HeaderField("DataDictionary.IacucProtocol.attributes.expirationDate", expirationDateStr);
        this.getDocInfo().add(expirationDate);
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ProtocolOnlineReviewService onlineReviewService = this.getProtocolOnlineReviewService();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        boolean onlineReviewTabEnabled = false;
        if (this.getProtocolDocument() != null && this.getProtocolDocument().getProtocol() != null) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            ProtocolSubmissionBase submission = this.getProtocolDocument().getProtocol().getProtocolSubmission();
            boolean isUserOnlineReviewer = onlineReviewService.isProtocolReviewer(principalId, false, submission);
            boolean isUserIacucAdmin = this.getKraAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", "IACUC Administrator");
            onlineReviewTabEnabled = (isUserOnlineReviewer || isUserIacucAdmin) && onlineReviewService.isProtocolInStateToBeReviewed(this.getProtocolDocument().getProtocol());
        }
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)"onlineReview")) {
                nav.setDisabled(!onlineReviewTabEnabled);
                if (!onlineReviewTabEnabled) {
                    if (onlineReviewTabEnabled) continue;
                    continue;
                }
                resultList.add(nav);
                continue;
            }
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return (ProtocolOnlineReviewService)KraServiceLocator.getService(IacucProtocolOnlineReviewService.class);
    }

    protected QuestionnaireHelperBase createNewQuestionnaireHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucQuestionnaireHelper((ProtocolFormBase)((IacucProtocolForm)protocolForm));
    }

    protected ActionHelperBase createNewActionHelperInstanceHook(ProtocolFormBase protocolForm) throws Exception {
        return new IacucActionHelper((ProtocolFormBase)((IacucProtocolForm)protocolForm));
    }

    protected ProtocolSpecialReviewHelperBase createNewSpecialReviewHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucProtocolSpecialReviewHelper((IacucProtocolForm)protocolForm);
    }

    protected ProtocolCustomDataHelperBase createNewCustomDataHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucProtocolCustomDataHelper((IacucProtocolForm)protocolForm);
    }

    protected OnlineReviewsActionHelperBase createNewOnlineReviewsActionHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new IacucOnlineReviewsActionHelper((IacucProtocolForm)protocolForm);
    }

    public IacucProtocolProceduresHelper getIacucProtocolProceduresHelper() {
        return this.iacucProtocolProceduresHelper;
    }

    public void setIacucProtocolProceduresHelper(IacucProtocolProceduresHelper iacucProtocolProceduresHelper) {
        this.iacucProtocolProceduresHelper = iacucProtocolProceduresHelper;
    }

    protected NotificationHelper<IacucProtocolNotificationContext> getNotificationHelperHook() {
        return new NotificationHelper();
    }

    protected IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return (IacucProtocolProcedureService)KraServiceLocator.getService((String)"iacucProtocolProcedureService");
    }

    public boolean isReinitializeModifySubmissionFields() {
        return this.reinitializeModifySubmissionFields;
    }

    public void setReinitializeModifySubmissionFields(boolean reinitializeModifySubmissionFields) {
        this.reinitializeModifySubmissionFields = reinitializeModifySubmissionFields;
    }

    public boolean isDefaultOpenCopyTab() {
        return this.defaultOpenCopyTab;
    }

    public void setDefaultOpenCopyTab(boolean defaultOpenCopyTab) {
        this.defaultOpenCopyTab = defaultOpenCopyTab;
    }

    protected List<String> getTerminalNodeNamesHook() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("IACUCReview");
        return retVal;
    }
}

