/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

@ParameterConstants.NAMESPACE(namespace="KC-IACUC")
@ParameterConstants.COMPONENT(component="Document")
public class IacucProtocolOnlineReviewDocument
extends ProtocolOnlineReviewDocumentBase {
    private static final long serialVersionUID = 43793212884887769L;
    private static final String DOCUMENT_TYPE_CODE = "PTRV";
    private static final Logger LOG = Logger.getLogger(IacucProtocolOnlineReviewDocument.class);
    private static final String OLR_DOC_ID_PARAM = "olrDocId";
    private static final String OLR_EVENT_PARAM = "olrEvent";
    private List<IacucProtocolOnlineReview> protocolOnlineReviewList = new ArrayList();

    public IacucProtocolOnlineReviewDocument() {
        IacucProtocolOnlineReview newProtocolReview = new IacucProtocolOnlineReview();
        newProtocolReview.setProtocolOnlineReviewDocument((ProtocolOnlineReviewDocumentBase)this);
        this.protocolOnlineReviewList.add(newProtocolReview);
    }

    public String serializeDocumentToXml() {
        for (ProtocolOnlineReviewBase protocolOnlineReview : this.getProtocolOnlineReviewList()) {
            ProtocolBase protocol = protocolOnlineReview.getProtocol();
            protocol.getLeadUnitNumber();
        }
        String xml = super.serializeDocumentToXml();
        return xml;
    }

    public void initialize() {
        super.initialize();
    }

    public ProtocolOnlineReviewBase getProtocolOnlineReview() {
        if (this.protocolOnlineReviewList.size() == 0) {
            return null;
        }
        return (ProtocolOnlineReviewBase)this.protocolOnlineReviewList.get(0);
    }

    public void setProtocolOnlineReview(ProtocolOnlineReviewBase protocolOnlineReview) {
        this.protocolOnlineReviewList.set(0, (IacucProtocolOnlineReview)protocolOnlineReview);
    }

    public List<IacucProtocolOnlineReview> getProtocolOnlineReviewList() {
        return this.protocolOnlineReviewList;
    }

    public void setProtocolOnlineReviewList(List<IacucProtocolOnlineReview> protocolOnlineReviewList) {
        this.protocolOnlineReviewList = protocolOnlineReviewList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        if (this.getProtocolOnlineReview() != null) {
            managedLists.addAll(this.getProtocolOnlineReview().buildListOfDeletionAwareLists());
        }
        managedLists.add(this.protocolOnlineReviewList);
        return managedLists;
    }

    protected List<RolePersons> getAllRolePersons() {
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return new ArrayList<RolePersons>();
    }

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (StringUtils.equals((String)statusChangeEvent.getNewRouteStatus(), (String)"X") || StringUtils.equals((String)statusChangeEvent.getNewRouteStatus(), (String)"D")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("ProtocolBase Online Review Document %s has been cancelled, deleting associated review comments.", this.getDocumentNumber()));
            }
            ArrayList deletedReviewAttachments = new ArrayList();
            this.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("X");
            this.getBusinessObjectService().save((PersistableBusinessObject)this.getProtocolOnlineReview());
        }
    }

    public void doActionTaken(ActionTakenEvent event) {
        super.doActionTaken(event);
    }

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private ReviewCommentsService getReviewerCommentsService() {
        return (ReviewCommentsService)KraServiceLocator.getService(ReviewCommentsService.class);
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    public boolean isProcessComplete() {
        boolean isComplete = true;
        String backLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
        String olrDocId = this.getURLParamValue(backLocation, OLR_DOC_ID_PARAM);
        if (olrDocId != null) {
            String olrEvent = this.getURLParamValue(backLocation, OLR_EVENT_PARAM);
            if (StringUtils.equalsIgnoreCase((String)olrEvent, (String)"Approve")) {
                isComplete = this.isOnlineReviewApproveComplete(olrDocId);
            } else if (StringUtils.equalsIgnoreCase((String)olrEvent, (String)"Reject")) {
                isComplete = this.isOnlineReviewRejectComplete(olrDocId);
            }
        }
        return isComplete;
    }

    private WorkflowDocumentService getWorkflowDocumentService() {
        return KRADServiceLocatorWeb.getWorkflowDocumentService();
    }

    private boolean isOnlineReviewApproveComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("OnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private boolean isOnlineReviewRejectComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (!this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("OnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    private String getURLParamValue(String url, String paramName) {
        String paramString;
        String pValue = null;
        if (StringUtils.isNotBlank((String)url) && url.indexOf("?") > -1 && StringUtils.isNotBlank((String)(paramString = url.substring(url.indexOf("?") + 1)))) {
            String[] params;
            for (String param : params = paramString.split("&")) {
                String[] temp = param.split("=");
                if (!StringUtils.equals((String)temp[0], (String)paramName)) continue;
                pValue = temp[1];
            }
        }
        return pValue;
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return null;
    }
}

