/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rule.event.AddNotificationRecipientEvent;
import org.kuali.kra.common.notification.rule.event.SendNotificationEvent;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolNotificationEditorAction
extends IacucProtocolAction {
    private static final String PROTOCOL_ACTIONS_TAB = "iacucProtocolActions";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getNotificationHelper().prepareView();
        return actionForward;
    }

    public ActionForward addNotificationRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List notificationRecipients;
        NotificationTypeRecipient notificationRecipient;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        if (this.applyRules((KualiDocumentEvent)new AddNotificationRecipientEvent((Document)document, notificationRecipient = protocolForm.getNotificationHelper().getNewNotificationRecipient(), notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients()))) {
            protocolForm.getNotificationHelper().getNotificationRecipients().add(notificationRecipient);
            protocolForm.getNotificationHelper().setNewNotificationRecipient(new NotificationTypeRecipient());
            protocolForm.getNotificationHelper().setNewRoleId(null);
            protocolForm.getNotificationHelper().setNewPersonId(null);
            protocolForm.getNotificationHelper().setNewRolodexId(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteNotificationRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getNotificationHelper().getNotificationRecipients().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List notificationRecipients;
        KcNotification notification;
        ActionForward actionForward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        if (this.applyRules((KualiDocumentEvent)new SendNotificationEvent((Document)document, notification = protocolForm.getNotificationHelper().getNotification(), notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients()))) {
            protocolForm.getNotificationHelper().sendNotificationAndPersist((KcNotification)new IacucProtocolNotification(), (KraPersistableBusinessObjectBase)document.getProtocol());
            String forwardName = ((ProtocolNotificationContextBase)protocolForm.getNotificationHelper().getNotificationContext()).getForwardName();
            protocolForm.getNotificationHelper().setNotificationContext(null);
            if (StringUtils.isNotBlank((String)forwardName)) {
                if (StringUtils.startsWith((String)forwardName, (String)"holdingPage")) {
                    if (StringUtils.equals((String)forwardName, (String)"holdingPage")) {
                        return this.routeProtocolToHoldingPage(mapping, protocolForm);
                    }
                    String[] params = StringUtils.split((String)forwardName, (String)":");
                    return this.routeProtocolOLRToHoldingPage(mapping, protocolForm, params[1], params[2]);
                }
                actionForward = mapping.findForward(forwardName);
            } else {
                this.recordProtocolActionSuccess("Send Notification");
                actionForward = mapping.findForward(PROTOCOL_ACTIONS_TAB);
            }
        }
        Object notificationRequestBeans = GlobalVariables.getUserSession().retrieveObject("removeReviewer");
        return actionForward;
    }

    private KcNotificationService getKcNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward cancelNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getNotificationHelper().setNotificationContext(null);
        return mapping.findForward(PROTOCOL_ACTIONS_TAB);
    }

    private ActionForward routeProtocolOLRToHoldingPage(ActionMapping mapping, IacucProtocolForm protocolForm, String olrDocId, String olrEvent) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "onlineReview", "ProtocolDocument");
        returnLocation = returnLocation + "&olrDocId=" + olrDocId + "&" + "olrEvent=" + olrEvent;
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        GlobalVariables.getUserSession().addObject("holdingPageDocumentId", (Object)olrDocId);
        GlobalVariables.getUserSession().addObject("alternateDocIdSessionKey", (Object)"holdingPageDocumentId");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, IacucProtocolForm protocolForm) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "protocolActions", "IacucProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }
}

