/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class IacucProtocolReviewerValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = 8186396635481365939L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmissionBase submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        ProtocolBase protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            List reviewers = submission.getProtocolReviewers();
            for (ProtocolReviewer reviewer : reviewers) {
                keyValues.add((KeyValue)new ConcreteKeyValue(reviewer.getProtocolReviewerId().toString(), reviewer.getFullName()));
            }
        }
        return keyValues;
    }

    private ProtocolSubmissionBase getCurrentSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"103") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102")) continue;
            return submission;
        }
        return null;
    }

    private ProtocolBase getProtocol() {
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof IacucProtocolForm) {
            return ((IacucProtocolForm)form).getProtocolDocument().getProtocol();
        }
        return null;
    }

    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

