/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.approve;

import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveBean;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveServiceImplBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;

public class IacucProtocolApproveServiceImpl
extends ProtocolApproveServiceImplBase
implements IacucProtocolApproveService {
    private static final String FULL_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of full approval action on protocol.";

    public void grantFullApproval(ProtocolBase protocol, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocol, actionBean, "204");
        if (protocol.getApprovalDate() == null) {
            protocol.setApprovalDate(actionBean.getApprovalDate());
        }
        if (protocol.getExpirationDate() == null) {
            protocol.setExpirationDate(actionBean.getExpirationDate());
        }
        if (protocol.isRenewal() || ((IacucProtocol)protocol).isContinuation() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        this.finalizeReviewsAndSave(protocol, "204", FULL_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    protected String getProtocolActionTypeCodeForAdminApprovalHook() {
        return "215";
    }

    protected String getProtocolActionTypeCodeForResponseApprovalHook() {
        return "205";
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, Object object, String protocolActionTypeCode) {
        return new IacucProtocolAction((IacucProtocol)protocol, null, protocolActionTypeCode);
    }

    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String protocolActionTypeCode) {
        return new IacucProtocolActionsCorrespondence(protocolActionTypeCode);
    }
}

