/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.assignagenda;

import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;

public class IacucProtocolAssignToAgendaBean
extends IacucProtocolGenericActionBean
implements ProtocolAssignToAgendaBean {
    private static final long serialVersionUID = -1671485882883282877L;
    private String committeeId = "";
    private String committeName = "";
    private String scheduleDate = "";
    private boolean protocolAssigned;
    private transient IacucProtocolAssignToAgendaService agendaService;

    public IacucProtocolAssignToAgendaBean(IacucActionHelper actionHelper) {
        super(actionHelper, "actionHelper.assignToAgendaBean");
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public void setCommitteName(String committeName) {
        this.committeName = committeName;
    }

    public void setScheduleDate(String scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public void setProtocolAssigned(boolean protocolAssigned) {
        this.protocolAssigned = protocolAssigned;
    }

    private IacucProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        if (this.agendaService == null) {
            this.agendaService = (IacucProtocolAssignToAgendaService)KraServiceLocator.getService(IacucProtocolAssignToAgendaService.class);
        }
        return this.agendaService;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public String getCommitteName() {
        return this.committeName;
    }

    public String getScheduleDate() {
        return this.scheduleDate;
    }

    public boolean isProtocolAssigned() {
        return this.protocolAssigned;
    }

    public void prepareView() {
        if (this.getProtocol() != null && this.getProtocol().getProtocolNumber() != null && !"protocolAssignToAgenda".equalsIgnoreCase(this.getActionHelper().getCurrentTask())) {
            String assignedCommitteeId = this.getProtocolAssignToAgendaService().getAssignedCommitteeId(this.getProtocol());
            if (assignedCommitteeId != null) {
                this.committeeId = assignedCommitteeId;
                this.committeName = this.getProtocolAssignToAgendaService().getAssignedCommitteeName(this.getProtocol());
                this.setComments(this.getProtocolAssignToAgendaService().getAssignToAgendaComments(this.getProtocol()));
                this.protocolAssigned = this.getProtocolAssignToAgendaService().isAssignedToAgenda(this.getProtocol());
                this.scheduleDate = this.getProtocolAssignToAgendaService().getAssignedScheduleDate(this.getProtocol());
            }
            if (this.getComments() == null) {
                this.setComments("");
            }
        }
        if (this.getActionHelper().getProtocolForm().isJavaScriptEnabled()) {
            // empty if block
        }
    }

    public Printable getCorrespondence() {
        IacucProtocolActionsCorrespondence correspondence = new IacucProtocolActionsCorrespondence("200");
        return correspondence;
    }
}

