/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.assignreviewers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.assignreviewers.ProtocolAssignReviewersBean;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;

public class IacucProtocolAssignReviewersBean
extends IacucProtocolActionBean
implements ProtocolAssignReviewersBean {
    private static final long serialVersionUID = -3769655019628462999L;
    private String currentCommitteeId = null;
    private String currentScheduleId = null;
    private List<ProtocolReviewerBeanBase> reviewers = new ArrayList();

    public IacucProtocolAssignReviewersBean(IacucActionHelper actionHelper) {
        super((ActionHelperBase)actionHelper);
    }

    public void prepareView() {
        ProtocolSubmissionBase submission = this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            String committeeId = submission.getCommitteeId();
            String scheduleId = submission.getScheduleId();
            if (!StringUtils.equals((String)committeeId, (String)this.currentCommitteeId) || !StringUtils.equals((String)scheduleId, (String)this.currentScheduleId)) {
                this.currentCommitteeId = committeeId;
                this.currentScheduleId = scheduleId;
                this.reviewers.clear();
                if (!StringUtils.isBlank((String)committeeId) && !StringUtils.isBlank((String)scheduleId)) {
                    List members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(committeeId, scheduleId));
                    for (CommitteeMembershipBase member : members) {
                        this.reviewers.add(new IacucProtocolReviewerBean(member));
                    }
                    block1: for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
                        if (!review.isActive()) continue;
                        for (ProtocolReviewerBeanBase reviewerBean : this.reviewers) {
                            if (!reviewerBean.isProtocolReviewerBeanForReviewer(review.getProtocolReviewer())) continue;
                            reviewerBean.setReviewerTypeCode(review.getProtocolReviewer().getReviewerTypeCode());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    private IacucCommitteeService getCommitteeService() {
        return (IacucCommitteeService)KraServiceLocator.getService(IacucCommitteeService.class);
    }

    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    public ProtocolReviewerBeanBase getReviewer(int i) {
        return (ProtocolReviewerBeanBase)this.reviewers.get(i);
    }

    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return leftReviewers;
    }

    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return rightReviewers;
    }
}

