/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.common.committee.bo.CommitteeDecisionMotionType;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteAbstaineeBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteRecusedBase;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteePerson;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.meeting.IacucProtocolVoteAbstainee;
import org.kuali.kra.iacuc.committee.meeting.IacucProtocolVoteRecused;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewAttachmentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucCommitteeDecision
extends IacucProtocolActionBean
implements CommitteeDecision<IacucCommitteePerson> {
    private static final long serialVersionUID = -8052093280852074307L;
    private String motionTypeCode;
    private Integer noCount;
    private Integer yesCount;
    private Integer abstainCount;
    private Integer recusedCount;
    private String votingComments;
    private CommitteeDecisionMotionType motionType;
    private IacucCommitteePerson newAbstainer = new IacucCommitteePerson();
    private IacucCommitteePerson newRecused = new IacucCommitteePerson();
    private List<IacucCommitteePerson> abstainers = new ArrayList();
    private List<IacucCommitteePerson> recused = new ArrayList();
    private List<IacucCommitteePerson> abstainersToDelete = new ArrayList();
    private List<IacucCommitteePerson> recusedToDelete = new ArrayList();
    private IacucReviewCommentsBean reviewCommentsBean = new IacucReviewCommentsBean("actionHelper.committeeDecision");

    public IacucCommitteeDecision(IacucActionHelper actionHelper) {
        super((ActionHelperBase)actionHelper);
    }

    public void init() {
        IacucProtocolSubmission submission = (IacucProtocolSubmission)this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            this.motionTypeCode = submission.getCommitteeDecisionMotionTypeCode();
            this.noCount = submission.getNoVoteCount();
            this.yesCount = submission.getYesVoteCount();
            this.abstainCount = submission.getAbstainerCount();
            this.recusedCount = submission.getRecusedCount();
            this.votingComments = submission.getVotingComments();
            this.setMotionType(submission.getCommitteeDecisionMotionType());
            if (submission.getScheduleIdFk() != null) {
                this.initializeAbstainees(submission);
                this.initializeRecused(submission);
            }
        }
    }

    public Integer getRecusedCount() {
        return this.getRecused().size();
    }

    public void setRecusedCount(Integer recusedCount) {
        this.recusedCount = recusedCount;
    }

    private Map<String, Long> getLookUpFields(Long protocolId, Long submissionIdFk) {
        HashMap<String, Long> lookUpFields = new HashMap<String, Long>();
        lookUpFields.put("protocolIdFk", protocolId);
        lookUpFields.put("submissionIdFk", submissionIdFk);
        return lookUpFields;
    }

    private List<CommitteeMembershipBase> getCommitteeMemberships() {
        String committeeId = this.getProtocol().getProtocolSubmission().getCommittee().getCommitteeId();
        String scheduleId = this.getProtocol().getProtocolSubmission().getScheduleId();
        List committeeMemberships = ((IacucCommitteeService)KraServiceLocator.getService(IacucCommitteeService.class)).getAvailableMembers(committeeId, scheduleId);
        return committeeMemberships;
    }

    private void initializeAbstainees(IacucProtocolSubmission submission) {
        Map absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteAbstainees = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatching(IacucProtocolVoteAbstainee.class, absenteeLookFields);
        List committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteAbstaineeBase abstainee : protocolVoteAbstainees) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!abstainee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                IacucCommitteePerson person = new IacucCommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.abstainers.add(person);
                continue block0;
            }
        }
    }

    private void initializeRecused(IacucProtocolSubmission submission) {
        Map absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteRecused = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatching(IacucProtocolVoteRecused.class, absenteeLookFields);
        List committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteRecusedBase recusee : protocolVoteRecused) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!recusee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                IacucCommitteePerson person = new IacucCommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.recused.add(person);
                continue block0;
            }
        }
    }

    public String getMotionTypeCode() {
        return this.motionTypeCode;
    }

    public void setMotionTypeCode(String commDecisionMotionTypeCode) {
        this.motionTypeCode = commDecisionMotionTypeCode;
    }

    public Integer getNoCount() {
        return this.noCount;
    }

    public void setNoCount(Integer noCount) {
        this.noCount = noCount;
    }

    public Integer getYesCount() {
        return this.yesCount;
    }

    public void setYesCount(Integer yesCount) {
        this.yesCount = yesCount;
    }

    public Integer getAbstainCount() {
        return this.getAbstainers().size();
    }

    public void setAbstainCount(Integer abstainCount) {
        this.abstainCount = abstainCount;
    }

    public String getVotingComments() {
        return this.votingComments;
    }

    public void setVotingComments(String votingComments) {
        this.votingComments = votingComments;
    }

    public CommitteeDecisionMotionType getMotionType() {
        return this.motionType;
    }

    public void setMotionType(CommitteeDecisionMotionType motionType) {
        this.motionType = motionType;
    }

    public List<IacucCommitteePerson> getAbstainers() {
        return this.abstainers;
    }

    public void setAbstainers(List<IacucCommitteePerson> abstainers) {
        this.abstainers = abstainers;
    }

    public List<IacucCommitteePerson> getAbstainersToDelete() {
        return this.abstainersToDelete;
    }

    public List<IacucCommitteePerson> getRecused() {
        return this.recused;
    }

    public void setRecused(List<IacucCommitteePerson> recused) {
        this.recused = recused;
    }

    public List<IacucCommitteePerson> getRecusedToDelete() {
        return this.recusedToDelete;
    }

    public IacucCommitteePerson getNewAbstainer() {
        return this.newAbstainer;
    }

    public void setNewAbstainer(IacucCommitteePerson newAbstainer) {
        this.newAbstainer = newAbstainer;
    }

    public IacucCommitteePerson getNewRecused() {
        return this.newRecused;
    }

    public void setNewRecused(IacucCommitteePerson newRecused) {
        this.newRecused = newRecused;
    }

    public int getTotalVoteCount() {
        return (this.getYesCount() != null ? this.getYesCount() : 0) + (this.getNoCount() != null ? this.getNoCount() : 0) + (this.getAbstainCount() != null ? this.getAbstainCount() : 0) + (this.getRecusedCount() != null ? this.getRecusedCount() : 0);
    }

    public IacucReviewCommentsBean getReviewCommentsBean() {
        return this.reviewCommentsBean;
    }

    public void setReviewCommentsBean(ReviewCommentsBeanBase reviewCommentsBean) {
        this.reviewCommentsBean = (IacucReviewCommentsBean)reviewCommentsBean;
    }

    public ReviewAttachmentsBeanBase getReviewAttachmentsBean() {
        return null;
    }

    public int getYesCountValue() {
        return this.getYesCount() != null ? this.getYesCount() : 0;
    }

    public int getNoCountValue() {
        return this.getNoCount() != null ? this.getNoCount() : 0;
    }
}

