/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.decision;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class IacucCommitteeMemberValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = 1547047028487421985L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmissionBase submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        ProtocolBase protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            String committeeId = submission.getCommitteeId();
            CommitteeBase committee = this.getCommitteeService().getCommitteeById(committeeId);
            if (committee != null) {
                List members = committee.getCommitteeMemberships();
                for (CommitteeMembershipBase member : members) {
                    if (!member.isActive() || !this.isReviewerAttendingMeeting(member)) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(member.getCommitteeMembershipId().toString(), member.getPersonName()));
                }
            }
        }
        return keyValues;
    }

    private ProtocolSubmissionBase getCurrentSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"103") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102")) continue;
            return submission;
        }
        return null;
    }

    private ProtocolBase getProtocol() {
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof ProtocolFormBase) {
            return ((ProtocolFormBase)form).getProtocolDocument().getProtocol();
        }
        return null;
    }

    private boolean isReviewerAttendingMeeting(CommitteeMembershipBase member) {
        CommitteeScheduleBase schedule;
        ProtocolBase prot = this.getProtocol();
        boolean retVal = false;
        if (prot != null && (schedule = prot.getProtocolSubmission().getCommitteeSchedule()) != null) {
            List attendees = schedule.getCommitteeScheduleAttendances();
            for (CommitteeScheduleAttendanceBase attendee : attendees) {
                if (!attendee.isCommitteeMember(member)) continue;
                return true;
            }
        }
        return retVal;
    }

    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

