/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.genericactions;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;

public class IacucProtocolGenericActionServiceImpl
extends ProtocolGenericActionServiceImplBase
implements IacucProtocolGenericActionService {
    public void disapprove(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "301", "303");
        this.performDisapprove(protocol);
    }

    public void expire(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "302", "308");
    }

    public ProtocolDocumentBase returnForSMR(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "209", "104");
        return this.getReturnedVersionedDocument(protocol);
    }

    public ProtocolDocumentBase returnForSRR(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "211", "107");
        return this.getReturnedVersionedDocument(protocol);
    }

    public ProtocolDocumentBase returnToPI(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "210", "102");
        return this.getReturnedVersionedDocument(protocol);
    }

    public void suspend(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "307", "304");
    }

    public void terminate(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "306", "307");
    }

    public void iacucAcknowledgement(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "206", protocol.getProtocolStatusCode());
    }

    public void iacucHold(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "305", "201");
    }

    public void iacucLiftHold(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        ProtocolActionBase selectedPa = null;
        for (ProtocolActionBase pa : protocol.getProtocolActions()) {
            System.err.println("pa.getProtocolActionTypeCode(): " + pa.getProtocolActionTypeCode());
            if (!StringUtils.equalsIgnoreCase((String)pa.getProtocolActionTypeCode(), (String)"305") || selectedPa != null && pa.getSequenceNumber() <= selectedPa.getSequenceNumber()) continue;
            selectedPa = pa;
        }
        this.performGenericAction(protocol, actionBean, "208", selectedPa.getPrevProtocolStatusCode());
    }

    public void iacucDeactivate(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "303", "305");
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase submission, String protocolActionType) {
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)submission, protocolActionType);
    }

    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondenceHook(String protocolActionType) {
        return new IacucProtocolActionsCorrespondence(protocolActionType);
    }

    protected String getProtocolPendingInProgressStatusCodeHook() {
        return "100";
    }

    protected String getProtocolSubmissionStatusRejectedInRoutingCodeHook() {
        return "401";
    }

    protected ProtocolActionBase getNewDisapprovedInRoutingProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, null, "401");
    }

    protected String getDisapprovedProtocolStatusCodeHook() {
        return "303";
    }

    protected String getRecallProtocolActionTypeCodeHook() {
        return null;
    }
}

