/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.modifysubmission;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionService;
import org.kuali.kra.iacuc.actions.processBillable.IacucProtocolProcessBillableService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.notification.IacucProtocolAssignReviewerNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRequestBean;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRequestBeanBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolModifySubmissionServiceImpl
extends IacucProtocolProcessBillableService
implements IacucProtocolModifySubmissionService {
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private IacucProtocolOnlineReviewService protocolOnlineReviewService;
    private KcNotificationService kcNotificationService;
    private CommitteeServiceBase committeeService;
    private static final String NEXT_ACTION_ID_KEY = "actionId";

    public void modifySubmission(ProtocolDocumentBase protocolDocument, IacucProtocolModifySubmissionBean bean, List<ProtocolReviewerBeanBase> beans) throws Exception {
        ProtocolSubmissionBase submission = protocolDocument.getProtocol().getProtocolSubmission();
        submission.setSubmissionTypeCode(bean.getSubmissionTypeCode());
        submission.setSubmissionTypeQualifierCode(bean.getSubmissionQualifierTypeCode());
        this.setSchedule(submission, bean.getCommitteeId(), bean.getScheduleId());
        this.processBillable(protocolDocument.getProtocol(), bean.isBillable());
        String existingReviewType = submission.getProtocolReviewTypeCode();
        String newReviewType = bean.getProtocolReviewTypeCode();
        if (!existingReviewType.equals(newReviewType)) {
            this.proccessNewReviewType(submission, newReviewType);
        }
        this.assignReviewers(submission, beans, bean);
        this.addNewAction((IacucProtocol)protocolDocument.getProtocol(), bean, submission.getSubmissionStatusCode());
        if (submission.getCommittee() != null) {
            submission.setSubmissionStatusCode("102");
        } else {
            submission.setSubmissionStatusCode("101");
        }
        this.documentService.saveDocument((Document)protocolDocument);
    }

    private void addNewAction(IacucProtocol protocol, IacucProtocolModifySubmissionBean actionBean, String prevSubmissionStatusCode) {
        ProtocolActionBase lastAction = protocol.getLastProtocolAction();
        IacucProtocolAction newAction = new IacucProtocolAction();
        newAction.setActionId(protocol.getNextValue(NEXT_ACTION_ID_KEY));
        newAction.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setProtocolActionTypeCode("309");
        newAction.setSubmissionIdFk(lastAction.getSubmissionIdFk());
        newAction.setSubmissionNumber(lastAction.getSubmissionNumber());
        newAction.setProtocolNumber(protocol.getProtocolNumber());
        newAction.setProtocolId(protocol.getProtocolId());
        newAction.setSequenceNumber(protocol.getSequenceNumber());
        newAction.setPrevSubmissionStatusCode(prevSubmissionStatusCode);
        newAction.setComments("ModifyProtocolSubmission");
        protocol.getProtocolActions().add(newAction);
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    public void setSchedule(ProtocolSubmissionBase submission, String committeeId, String scheduleId) {
        if (!this.setCommittee(submission, committeeId)) {
            submission.setScheduleId(null);
            submission.setScheduleIdFk(null);
            submission.setCommitteeSchedule(null);
        } else {
            CommitteeScheduleBase schedule = this.committeeService.getCommitteeSchedule(submission.getCommittee(), scheduleId);
            if (schedule == null) {
                submission.setScheduleId(null);
                submission.setScheduleIdFk(null);
                submission.setCommitteeSchedule(null);
                this.updateDefaultSchedule(submission);
            } else {
                submission.setScheduleId(schedule.getScheduleId());
                submission.setScheduleIdFk(schedule.getId());
                submission.setCommitteeSchedule(schedule);
                this.updateDefaultSchedule(submission);
            }
        }
    }

    protected void updateDefaultSchedule(ProtocolSubmissionBase submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        List minutes = (List)this.businessObjectService.findMatching(IacucCommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinuteBase minute : minutes) {
                if (submission.getScheduleIdFk() == null) {
                    minute.setScheduleIdFk(CommitteeScheduleBase.DEFAULT_SCHEDULE_ID);
                    continue;
                }
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    public boolean setCommittee(ProtocolSubmissionBase submission, String committeeId) {
        CommitteeBase committee = this.committeeService.getCommitteeById(committeeId);
        if (committee == null) {
            submission.setCommitteeId(null);
            submission.setCommitteeIdFk(null);
            submission.setCommittee(null);
            return false;
        }
        submission.setCommitteeId(committee.getCommitteeId());
        submission.setCommitteeIdFk(committee.getId());
        submission.setCommittee(committee);
        return true;
    }

    public String getAssignedScheduleId(ProtocolBase protocol) {
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        if (submission != null && StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102")) {
            return submission.getScheduleId();
        }
        return null;
    }

    protected ProtocolSubmissionBase findSubmission(ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = null;
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102")) continue;
            protocolSubmission = submission;
        }
        return protocolSubmission;
    }

    protected void removeReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase protocolReviewBean, String annotation) {
        ProtocolOnlineReviewDocumentBase onlineReviewDocument = this.protocolOnlineReviewService.getProtocolOnlineReviewDocument(protocolReviewBean.getPersonId(), protocolReviewBean.getNonEmployeeFlag(), protocolSubmission);
        if (onlineReviewDocument != null) {
            ProtocolBase protocol = protocolSubmission.getProtocol();
            ProtocolOnlineReviewBase protocolOnlineReview = onlineReviewDocument.getProtocolOnlineReview();
            protocolReviewBean.setNotificationRequestBean((ProtocolNotificationRequestBeanBase)new IacucProtocolNotificationRequestBean((IacucProtocol)protocol, (IacucProtocolOnlineReview)protocolOnlineReview, "901", "Assign Reviewer", null, null));
            protocolReviewBean.setActionFlag("remove");
            IacucProtocolAssignReviewerNotificationRenderer renderer = new IacucProtocolAssignReviewerNotificationRenderer((IacucProtocol)protocol, "removed");
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)protocol, (IacucProtocolOnlineReview)protocolOnlineReview, "901", "Assign Reviewer", (IacucProtocolNotificationRenderer)renderer);
            this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IacucProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
        }
        this.protocolOnlineReviewService.removeOnlineReviewDocument(protocolReviewBean.getPersonId(), protocolReviewBean.getNonEmployeeFlag(), protocolSubmission, annotation);
    }

    public void assignReviewers(ProtocolSubmissionBase protocolSubmission, List<ProtocolReviewerBeanBase> protocolReviewerBeans, IacucProtocolModifySubmissionBean protocolModifySubmissionBean) throws Exception {
        if (protocolSubmission != null) {
            for (ProtocolReviewerBeanBase bean : protocolReviewerBeans) {
                if (StringUtils.isNotBlank((String)bean.getReviewerTypeCode())) {
                    if (!this.protocolOnlineReviewService.isProtocolReviewer(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission)) {
                        this.createReviewer(protocolSubmission, bean, protocolModifySubmissionBean);
                        continue;
                    }
                    this.updateReviewer(protocolSubmission, bean, protocolModifySubmissionBean);
                    bean.setActionFlag("update");
                    continue;
                }
                if (!this.protocolOnlineReviewService.isProtocolReviewer(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission)) continue;
                this.removeReviewer(protocolSubmission, bean, "REVIEW REMOVED FROM ASSIGN REVIEWERS ACTION.");
            }
            this.businessObjectService.save((PersistableBusinessObject)protocolSubmission);
        }
    }

    protected void updateReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase protocolReviewerBean, IacucProtocolModifySubmissionBean protocolModifySubmissionBean) {
        ProtocolReviewer reviewer = this.protocolOnlineReviewService.getProtocolReviewer(protocolReviewerBean.getPersonId(), protocolReviewerBean.getNonEmployeeFlag(), protocolSubmission);
        reviewer.setReviewerTypeCode(protocolReviewerBean.getReviewerTypeCode());
        IacucProtocolOnlineReview iacucProtocolOnlineReview = null;
        for (ProtocolOnlineReviewBase onlineReview : reviewer.getProtocolOnlineReviews()) {
            if (!onlineReview.getSubmissionIdFk().equals(protocolSubmission.getSubmissionId())) continue;
            iacucProtocolOnlineReview = (IacucProtocolOnlineReview)onlineReview;
        }
        if (iacucProtocolOnlineReview != null && !DateUtils.isSameDay((java.util.Date)iacucProtocolOnlineReview.getDeterminationReviewDateDue(), (java.util.Date)protocolModifySubmissionBean.getDueDate())) {
            iacucProtocolOnlineReview.setDeterminationReviewDateDue(protocolModifySubmissionBean.getDueDate());
            this.businessObjectService.save((PersistableBusinessObject)iacucProtocolOnlineReview);
        }
        this.businessObjectService.save((PersistableBusinessObject)reviewer);
    }

    protected void createReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase protocolReviewerBean, IacucProtocolModifySubmissionBean protocolModifySubmissionBean) throws WorkflowException {
        String principalId = protocolReviewerBean.getPersonId();
        boolean nonEmployeeFlag = protocolReviewerBean.getNonEmployeeFlag();
        String reviewerTypeCode = protocolReviewerBean.getReviewerTypeCode();
        ProtocolReviewer reviewer = this.protocolOnlineReviewService.createProtocolReviewer(principalId, nonEmployeeFlag, reviewerTypeCode, protocolSubmission);
        ProtocolPersonBase protocolPerson = protocolSubmission.getProtocol().getPrincipalInvestigator();
        String protocolNumber = protocolSubmission.getProtocol().getProtocolNumber();
        String description = this.protocolOnlineReviewService.getProtocolOnlineReviewDocumentDescription(protocolNumber, protocolPerson.getLastName());
        String explanation = "";
        String organizationDocumentNumber = "";
        String routeAnnotation = "Online Review Requested by PI during protocol submission.";
        boolean initialApproval = false;
        Date dateRequested = null;
        Date dateDue = null;
        String sessionPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        ProtocolOnlineReviewDocumentBase document = this.protocolOnlineReviewService.createProtocolOnlineReviewDocument(protocolSubmission, reviewer, description, explanation, organizationDocumentNumber, dateRequested, dateDue, sessionPrincipalId);
        protocolSubmission.getProtocolOnlineReviews().add(document.getProtocolOnlineReview());
        this.documentService.routeDocument((Document)document, routeAnnotation, new ArrayList());
        IacucProtocol protocol = (IacucProtocol)protocolSubmission.getProtocol();
        ProtocolOnlineReviewBase protocolOnlineReview = document.getProtocolOnlineReview();
        protocolReviewerBean.setNotificationRequestBean((ProtocolNotificationRequestBeanBase)new IacucProtocolNotificationRequestBean(protocol, (IacucProtocolOnlineReview)protocolOnlineReview, "901", "Assign Reviewer", null, null));
        protocolReviewerBean.setActionFlag("create");
        IacucProtocolAssignReviewerNotificationRenderer renderer = new IacucProtocolAssignReviewerNotificationRenderer(protocol, "added");
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, (IacucProtocolOnlineReview)protocolOnlineReview, "901", "Assign Reviewer", (IacucProtocolNotificationRenderer)renderer);
        this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IacucProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
        ((IacucProtocolOnlineReview)protocolOnlineReview).setDeterminationReviewDateDue(protocolModifySubmissionBean.getDueDate());
    }

    protected void proccessNewReviewType(ProtocolSubmissionBase submission, String newReviewType) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("PROTOCOL_REVIEW_TYPE_CODE", newReviewType);
        ProtocolReviewTypeBase newType = (ProtocolReviewTypeBase)this.businessObjectService.findByPrimaryKey(IacucProtocolReviewType.class, fieldValues);
        submission.setProtocolReviewType(newType);
        submission.setProtocolReviewTypeCode(newType.getReviewTypeCode());
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKcNotificationService(KcNotificationService notificationService) {
        this.kcNotificationService = notificationService;
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = (IacucProtocolOnlineReviewService)protocolOnlineReviewService;
    }
}

