/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;

public class IacucProtocolActionMapping
extends ProtocolActionMappingBase {
    private static final Map<String, String> ACTION_TYPE_SUBMISSION_TYPE_MAP;
    private static final List<String> APPROVE_ACTION_TYPES;

    public IacucProtocolActionMapping(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        super(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
    }

    public boolean getSubmissionCount() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        HashMap negativeFieldValues = new HashMap();
        negativeFieldValues.put("submissionTypeCode", ACTION_TYPE_SUBMISSION_TYPE_MAP.get(this.actionTypeCode));
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues, negativeFieldValues) == 0;
    }

    public boolean getSubmissionCountCond2() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues) == 0;
    }

    public boolean getSubmissionCountCond4() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        positiveFieldValues.put("submissionTypeCode", Arrays.asList("102", "103"));
        return this.businessObjectService.countMatching(IacucProtocolSubmission.class, positiveFieldValues) == 0;
    }

    private List<String> getPendingSubmissionStatusCodes() {
        ArrayList<String> submissionStatusCodes = new ArrayList<String>();
        submissionStatusCodes.add("102");
        submissionStatusCodes.add("103");
        submissionStatusCodes.add("101");
        return submissionStatusCodes;
    }

    public boolean getSubmissionCountCond5() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(IacucProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return submissions.isEmpty() || !this.getPendingSubmissionStatusCodes().contains(((IacucProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    public boolean getSubmissionCountForWithdraw() {
        List<String> statusCodes = Arrays.asList("101", "102", "103");
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(IacucProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return !submissions.isEmpty() && statusCodes.contains(((IacucProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    public String toString() {
        return "IacucProtocolActionMapping = (submissionStatusCode = " + this.submissionStatusCode + ", submissionTypeCode = " + this.submissionTypeCode + ", protocolReviewTypeCode = " + this.protocolReviewTypeCode + ", actionTypeCode = " + this.actionTypeCode + ", protocolStatusCode = " + this.protocolStatusCode + ", scheduleId = " + this.scheduleId + ", protocol id = " + this.protocol.getProtocolId() + ", submissionNumber = " + this.submissionNumber + ", allowed = " + this.allowed + ")";
    }

    public boolean getSubmissionStatusForAdminAction() {
        boolean retVal = StringUtils.isNotBlank((String)this.protocol.getProtocolSubmission().getCommitteeId()) ? StringUtils.equals((String)this.submissionStatusCode, (String)"102") || StringUtils.equals((String)this.submissionStatusCode, (String)"103") || StringUtils.equals((String)this.submissionStatusCode, (String)"206") : StringUtils.equals((String)this.submissionStatusCode, (String)"101");
        return retVal;
    }

    protected Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook() {
        return IacucCommitteeScheduleMinute.class;
    }

    static {
        HashMap codeMap = new HashMap();
        ACTION_TYPE_SUBMISSION_TYPE_MAP = Collections.unmodifiableMap(codeMap);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("204");
        APPROVE_ACTION_TYPES = codes;
    }
}

