/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.drools.brms.FactBean;
import org.kuali.kra.drools.util.DroolsRuleHandler;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionDoc;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionMapping;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionUpdateMapping;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ActionRightMapping;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionUpdateMapping;
import org.kuali.kra.questionnaire.answer.AnswerHeader;

public class IacucProtocolActionServiceImpl
extends ProtocolActionServiceImplBase
implements IacucProtocolActionService {
    private static final Log LOG = LogFactory.getLog(IacucProtocolActionServiceImpl.class);
    protected static final int PERFORMACTION_RULE = 0;
    protected static final int UPDATE_RULE = 1;
    protected static final int PERMISSIONS_LEADUNIT_RULE = 2;
    protected static final int PERMISSIONS_SUBMIT_RULE = 3;
    protected static final int PERMISSIONS_COMMITTEEMEMBERS_RULE = 4;
    protected static final int PERMISSIONS_SPECIAL_RULE = 5;
    private static final String PERFORMACTION_FILE = "org/kuali/kra/iacuc/drools/rules/canPerformIacucProtocolActionRules.drl";
    private static final String UPDATE_FILE = "org/kuali/kra/iacuc/drools/rules/updateIacucProtocolRules.drl";
    private static final String KC_IACUC = "KC-IACUC";
    private static final String[] actionCodes = new String[]{"101", "102", "103", "104", "105", "106", "107", "108", "109", "113", "114", "115", "117", "200", "312", "202", "203", "204", "205", "206", "207", "208", "209", "210", "211", "212", "213", "214", "215", "216", "300", "301", "302", "303", "304", "305", "306", "307"};

    public String getPerformActionFileNameHook() {
        return PERFORMACTION_FILE;
    }

    protected boolean hasPermissionLeadUnit(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(2)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), protocol.getLeadUnitNumber(), KC_IACUC, "Modify Any IACUC Protocol") : false;
    }

    protected boolean hasPermissionToSubmit(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(3)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (Permissionable)protocol, rightMapper.getRightId()) : false;
    }

    protected boolean hasPermissionAsCommitteeMember(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        rightMapper.setCommitteeId(protocol.getProtocolSubmission().getCommitteeId());
        rightMapper.setScheduleId(protocol.getProtocolSubmission().getScheduleId());
        ((DroolsRuleHandler)this.rulesList.get(4)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), protocol.getLeadUnitNumber(), KC_IACUC, "Perform IACUC Actions on Protocol") : false;
    }

    protected boolean hasPermissionSpecialCase(String actionTypeCode, String unit, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(5)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), unit, KC_IACUC, "Perform IACUC Actions on Protocol") : false;
    }

    public void resetProtocolStatus(ProtocolActionBase protocolActionBo, ProtocolBase protocol) {
        IacucProtocolAction protocolAction = (IacucProtocolAction)protocolActionBo;
        if (protocolAction.getPrevProtocolStatusCode() != null) {
            protocol.setProtocolStatusCode(protocolAction.getPrevProtocolStatusCode());
            protocol.refreshReferenceObject("protocolStatus");
        }
        if (protocolAction.getPrevSubmissionStatusCode() != null) {
            protocol.getProtocolSubmission().setSubmissionStatusCode(protocolAction.getPrevSubmissionStatusCode());
        }
        if (protocolAction.isCreatedSubmission()) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionIdFk", protocolAction.getProtocolSubmission().getSubmissionId().toString());
            fieldValues.put("protocolNumber", protocol.getProtocolNumber());
            this.businessObjectService.deleteMatching(IacucProtocolSubmissionDoc.class, fieldValues);
            this.removeQuestionnaireAnswer((ProtocolActionBase)protocolAction, protocol);
            protocol.getProtocolSubmissions().remove(protocolAction.getProtocolSubmission());
            protocol.setProtocolSubmission(null);
        }
    }

    private void removeQuestionnaireAnswer(ProtocolActionBase protocolActionBo, ProtocolBase protocol) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleItemKey", protocol.getProtocolNumber());
        fieldValues.put("moduleSubItemCode", "2");
        fieldValues.put("moduleSubItemKey", protocolActionBo.getProtocolSubmission().getSubmissionNumber().toString());
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (!answerHeaders.isEmpty()) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected Log getLOGHook() {
        return LOG;
    }

    protected int getPerformActionRuleIndexHook() {
        return 0;
    }

    protected ProtocolActionMappingBase getNewProtocolActionMappingInstanceHook(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        return new IacucProtocolActionMapping(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
    }

    protected ProtocolActionUpdateMapping getNewProtocolActionUpdateMappingHook(String actionTypeCode, String submissionTypeCode, String protocolStatusCode, String specialCondition) {
        return new IacucProtocolActionUpdateMapping(actionTypeCode, submissionTypeCode, protocolStatusCode, specialCondition);
    }

    protected int getUpdateRuleIndexHook() {
        return 1;
    }

    protected String[] getActionCodesArrayHook() {
        return actionCodes;
    }
}

