/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.springframework.util.AutoPopulatingList;

public class IacucProtocolSubmitAction
extends IacucProtocolActionBean
implements ProtocolSubmitAction {
    private static final long serialVersionUID = 4456005318168340284L;
    private String submissionTypeCode = "";
    private String protocolReviewTypeCode = "";
    private String submissionQualifierTypeCode = "";
    protected String committeeId = "";
    protected String scheduleId = "";
    protected boolean committeeIdChanged = false;
    protected boolean scheduleIdChanged = false;
    protected boolean reviewerListAvailable = false;
    protected int numberOfReviewers = 0;
    protected List<ProtocolReviewerBeanBase> reviewers = new AutoPopulatingList(IacucProtocolReviewerBean.class);
    private String newCommitteeId = "";
    private String newScheduleId = "";
    private boolean javascriptEnabled = true;

    public IacucProtocolSubmitAction(ActionHelperBase actionHelper) {
        super(actionHelper);
    }

    protected Class<? extends ProtocolReviewerBeanBase> getProtocolReviewerBeanClassHook() {
        return IacucProtocolReviewerBean.class;
    }

    public void prepareView() {
        if (!this.getJavascriptEnabled()) {
            if (!(StringUtils.isBlank((String)this.committeeId) || this.committeeIdChanged || StringUtils.isBlank((String)this.scheduleId))) {
                if (this.scheduleIdChanged) {
                    this.reviewers.clear();
                }
            } else {
                this.reviewers.clear();
                this.reviewerListAvailable = false;
            }
        } else {
            this.reviewers.subList(this.numberOfReviewers, this.reviewers.size()).clear();
        }
    }

    public void setNumberOfReviewers(int numberOfReviewers) {
        this.numberOfReviewers = numberOfReviewers;
    }

    public CommitteeServiceBase getCommitteeService() {
        return (CommitteeServiceBase)KraServiceLocator.getService(IacucCommitteeService.class);
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    public String getSubmissionQualifierTypeCode() {
        return this.submissionQualifierTypeCode;
    }

    public void setSubmissionQualifierTypeCode(String submissionQualifierTypeCode) {
        this.submissionQualifierTypeCode = submissionQualifierTypeCode;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeIdChanged = true;
        if (StringUtils.equals((String)this.committeeId, (String)committeeId)) {
            this.committeeIdChanged = false;
        }
        this.committeeId = committeeId;
        this.newCommitteeId = committeeId;
    }

    public void setNewCommitteeId(String id) {
        this.newCommitteeId = id;
    }

    public String getNewCommitteeId() {
        return this.newCommitteeId;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleIdChanged = true;
        if (StringUtils.equals((String)this.scheduleId, (String)scheduleId)) {
            this.scheduleIdChanged = false;
        }
        this.scheduleId = scheduleId;
        this.newScheduleId = scheduleId;
    }

    public String getNewScheduleId() {
        return this.newScheduleId;
    }

    public boolean isReviewerListAvailable() {
        return this.reviewerListAvailable;
    }

    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    public ProtocolReviewerBeanBase getReviewer(int i) {
        return (ProtocolReviewerBeanBase)this.reviewers.get(i);
    }

    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return leftReviewers;
    }

    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return rightReviewers;
    }

    public void setReviewers(List<ProtocolReviewerBeanBase> reviewerBeans) {
        this.reviewers = reviewerBeans;
    }

    public boolean getJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public IacucProtocolSubmitAction(IacucActionHelper actionHelper) {
        super((ActionHelperBase)actionHelper);
    }
}

