/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitActionRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class IacucProtocolSubmitActionRule
extends ProtocolSubmitActionRuleBase {
    private final String PROTOCOL_ALT_SEARCH_REQUIRED_PROPERTY_KEY = "document.protocolList[0].iacucPrinciples[0].searchRequired";
    private final String PROTOCOL_ALT_SEARCH_PROPERTY_KEY = "iacucAlternateSearchHelper.newAlternateSearch.databases";
    private static final String PRINCIPLES_PANEL_NAME = "threeRs";
    private static final String PRINCIPLES_CLUSTER_NAME = "alternateSearchAuditErrors";
    private static final String PRINCIPLES_ANCHOR_NAME = "Alternate Search";

    public boolean processSubmitAction(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        boolean isValid = super.processSubmitAction(document, submitAction);
        return isValid &= this.validateThreeRs(submitAction);
    }

    private boolean validateThreeRs(ProtocolSubmitAction submitAction) {
        IacucProtocol protocol = (IacucProtocol)submitAction.getProtocol();
        String searchRequired = ((IacucPrinciples)protocol.getIacucPrinciples().get(0)).getSearchRequired();
        List auditErrors = this.getAuditErrors();
        if (StringUtils.isBlank((String)searchRequired)) {
            auditErrors.add(new AuditError("document.protocolList[0].iacucPrinciples[0].searchRequired", "error.iacuc.alt.search.question.not.answered", "threeRs.Alternate Search"));
        } else if (StringUtils.equals((String)"Y", (String)searchRequired) && protocol.getIacucAlternateSearches().isEmpty()) {
            auditErrors.add(new AuditError("iacucAlternateSearchHelper.newAlternateSearch.databases", "error.iacuc.alt.search.data.not.entered", "threeRs.Alternate Search"));
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(PRINCIPLES_CLUSTER_NAME, new AuditCluster(PRINCIPLES_ANCHOR_NAME, auditErrors, "Validation Errors"));
            return false;
        }
        return true;
    }

    protected Class<? extends ProtocolSubmissionTypeBase> getProtocolSubmissionTypeClassHook() {
        return IacucProtocolSubmissionType.class;
    }

    protected Class<? extends ProtocolReviewTypeBase> getProtocolReviewTypeClassHook() {
        return IacucProtocolReviewType.class;
    }

    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook() {
        return IacucProtocolDocument.class;
    }

    private List<AuditError> getAuditErrors() {
        List<Object> auditErrors = new ArrayList<AuditError>();
        auditErrors = !KNSGlobalVariables.getAuditErrorMap().containsKey(PRINCIPLES_CLUSTER_NAME) ? new ArrayList() : ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(PRINCIPLES_CLUSTER_NAME)).getAuditErrorList();
        return auditErrors;
    }
}

