/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolStatus;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionService;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolSubmitActionServiceImpl
implements IacucProtocolSubmitActionService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SUBMITTED_TO_IACUC = "SubmittedToIACUC";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private IacucProtocolFinderDao protocolFinderDao;
    private BusinessObjectService businessObjectService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setProtocolFinderDao(IacucProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public int getTotalSubmissions(IacucProtocol protocol) {
        int totalSubmissions = 0;
        for (IacucProtocolSubmission protocolSubmission : this.getProtocolSubmissions(protocol.getProtocolNumber())) {
            int submissionNumber = protocolSubmission.getSubmissionNumber();
            if (submissionNumber <= totalSubmissions || protocolSubmission.getSequenceNumber() > protocol.getSequenceNumber()) continue;
            totalSubmissions = submissionNumber;
        }
        return totalSubmissions;
    }

    public List<IacucProtocolSubmission> getProtocolSubmissions(String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PROTOCOL_NUMBER, protocolNumber);
        Collection submissions = this.businessObjectService.findMatching(IacucProtocolSubmission.class, fieldValues);
        return new ArrayList<IacucProtocolSubmission>(submissions);
    }

    public List<IacucProtocolSubmission> getProtocolSubmissions(String protocolNumber, int submissionNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(PROTOCOL_NUMBER, protocolNumber);
        fieldValues.put(SUBMISSION_NUMBER, submissionNumber);
        Collection submissions = this.businessObjectService.findMatching(IacucProtocolSubmission.class, fieldValues);
        return new ArrayList<IacucProtocolSubmission>(submissions);
    }

    private List<IacucProtocolSubmission> getProtocolSubmissionsLookupList(String protocolNumber, List<IacucProtocolSubmission> protocolSubmissionList) throws Exception {
        List<IacucProtocolSubmission> submissions = protocolSubmissionList;
        ArrayList protocolSubmissionLookupDataList = new ArrayList();
        ArrayList protocolSubmissionLookupResult = new ArrayList();
        return new ArrayList<IacucProtocolSubmission>(protocolSubmissionLookupResult);
    }

    public void submitToIacucForReview(IacucProtocol protocol, IacucProtocolSubmitAction submitAction) throws Exception {
        String prevSubmissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
        String submissionTypeCode = protocol.getProtocolSubmission().getSubmissionTypeCode();
        IacucProtocolSubmission submission = this.createProtocolSubmission(protocol, submitAction);
        if (protocol.getInitialSubmissionDate() == null) {
            protocol.setInitialSubmissionDate(new Date(submission.getSubmissionDate().getTime()));
        }
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, submission, "101");
        protocolAction.setComments(SUBMITTED_TO_IACUC);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatus);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocolAction.setCreatedSubmission(true);
        protocol.getProtocolActions().add(protocolAction);
        IacucProtocolStatus protocolStatus = new IacucProtocolStatus();
        protocolStatus.setProtocolStatusCode("101");
        protocolStatus.setDescription(SUBMITTED_TO_IACUC);
        protocol.setProtocolStatus((ProtocolStatusBase)protocolStatus);
        protocol.setProtocolStatusCode("101");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)protocolAction, (ProtocolBase)protocol);
        if (submission.getScheduleIdFk() != null) {
            this.updateDefaultSchedule(submission);
        }
        this.businessObjectService.delete(protocol.getProtocolDocument().getPessimisticLocks());
        protocol.getProtocolDocument().getPessimisticLocks().clear();
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        protocol.refresh();
    }

    protected void updateDefaultSchedule(IacucProtocolSubmission submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        fieldValues.put("scheduleIdFk", CommitteeScheduleBase.DEFAULT_SCHEDULE_ID.toString());
        List minutes = (List)this.businessObjectService.findMatching(IacucCommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinuteBase minute : minutes) {
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    protected void addActionToOriginalProtocol(String type, String origProtocolNumber, Integer submissionNumber) throws WorkflowException {
        String protocolNumber = origProtocolNumber.substring(0, 10);
        String index = origProtocolNumber.substring(11);
        ProtocolBase protocol = this.protocolFinderDao.findCurrentProtocolByNumber(protocolNumber);
        IacucProtocolAction protocolAction = new IacucProtocolAction((IacucProtocol)protocol, null, "101");
        protocolAction.setComments(type + "-" + index + ": " + SUBMITTED_TO_IACUC);
        protocolAction.setSubmissionNumber(submissionNumber);
        protocol.getProtocolActions().add(protocolAction);
        this.businessObjectService.save((PersistableBusinessObject)protocol);
    }

    protected IacucProtocolSubmission createProtocolSubmission(IacucProtocol protocol, IacucProtocolSubmitAction submitAction) {
        IacucProtocolSubmissionBuilder submissionBuilder = new IacucProtocolSubmissionBuilder(protocol, submitAction.getSubmissionTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(submitAction.getSubmissionQualifierTypeCode());
        submissionBuilder.setProtocolReviewTypeCode(submitAction.getProtocolReviewTypeCode());
        this.setSubmissionStatus(submissionBuilder, submitAction);
        this.setCommittee(submissionBuilder, submitAction);
        return submissionBuilder.create();
    }

    protected void setSubmissionStatus(IacucProtocolSubmissionBuilder submissionBuilder, IacucProtocolSubmitAction submitAction) {
        submissionBuilder.setSubmissionStatus("101");
    }

    protected void setCommittee(IacucProtocolSubmissionBuilder submissionBuilder, IacucProtocolSubmitAction submitAction) {
        submissionBuilder.setCommittee(submitAction.getNewCommitteeId());
    }

    public List<IacucProtocolSubmission> getProtocolSubmissionsLookupData(List<IacucProtocolSubmission> protocolSubmissionList) throws Exception {
        return null;
    }
}

