/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.auth.IacucProtocolAuthorizer;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreateProposalDevelopmentIacucProtocolAuthorizer
extends IacucProtocolAuthorizer {
    public boolean isAuthorized(String userId, IacucProtocolTask task) {
        IacucProtocol protocol = task.getProtocol();
        return this.canCreateProposal() && this.hasProposalRequiredFields((ProtocolBase)protocol);
    }

    private boolean canCreateProposal() {
        ApplicationTask task = new ApplicationTask("createProposal");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        boolean canCreateProposal = taskAuthenticationService.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)task);
        return canCreateProposal;
    }

    private boolean hasProposalRequiredFields(ProtocolBase protocol) {
        boolean validProposalRequiredFields = true;
        if (StringUtils.isEmpty((String)protocol.getTitle())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((String)protocol.getLeadUnitNumber())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((String)protocol.getPrincipalInvestigatorId())) {
            validProposalRequiredFields = false;
        }
        List protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceBase sponsorProtocolFundingSource = null;
        for (ProtocolFundingSourceBase protocolFundingSource : protocolFundingSources) {
            if (!protocolFundingSource.isSponsorFunding()) continue;
            sponsorProtocolFundingSource = protocolFundingSource;
            break;
        }
        if (sponsorProtocolFundingSource == null) {
            validProposalRequiredFields = false;
        }
        return validProposalRequiredFields;
    }
}

