/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.auth.GenericProtocolAuthorizer;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;

public class IacucGenericProtocolAuthorizer
extends GenericProtocolAuthorizer {
    public static final String EXPIRE_PROTOCOL = "iacucProtocolExpire";
    public static final String EXPIRE_UNAVAILABLE_PROTOCOL = "iacucProtocolExpireUnavailable";
    public static final String SUSPEND_PROTOCOL = "iacucProtocolSuspend";
    public static final String SUSPEND_UNAVAILABLE_PROTOCOL = "iacucProtocolUnavailableSuspend";
    public static final String TERMINATE_PROTOCOL = "iacucProtocolTerminate";
    public static final String TERMINATE_UNAVAILBLE_PROTOCOL = "iacucProtocolTerminateUnavailable";
    protected static final Map<String, String> TASK_NAME_TO_ACTION_TYPE_MAP = new HashMap();
    protected static final Map<String, String> TASK_NAME_TO_ROLE_NAME_MAP;
    private static final String ERROR_MESSAGE = "Please set genericTaskName with one of the static strings in this class.";
    private String genericTaskName;

    public boolean isAuthorized(String userId, ProtocolTaskBase task) {
        if (StringUtils.isEmpty((String)this.genericTaskName)) {
            this.genericTaskName = task.getTaskName();
        }
        return this.canExecuteAction(task.getProtocol(), this.convertGenericTaskNameToProtocolActionType()) && this.hasPermission(userId, task.getProtocol(), this.convertGenericTaskNameToPermissionNameType());
    }

    protected String convertGenericTaskNameToProtocolActionType() {
        if (TASK_NAME_TO_ACTION_TYPE_MAP.containsKey(this.genericTaskName)) {
            return (String)TASK_NAME_TO_ACTION_TYPE_MAP.get(this.genericTaskName);
        }
        throw new IllegalArgumentException("Please set genericTaskName with one of the static strings in this class.  this.genericTaskName: " + this.genericTaskName);
    }

    protected String convertGenericTaskNameToPermissionNameType() {
        if (TASK_NAME_TO_ROLE_NAME_MAP.containsKey(this.genericTaskName)) {
            return (String)TASK_NAME_TO_ROLE_NAME_MAP.get(this.genericTaskName);
        }
        throw new IllegalArgumentException("Please set genericTaskName with one of the static strings in this class.  this.genericTaskName: " + this.genericTaskName);
    }

    public void setGenericTaskName(String genericTaskName) {
        if (!TASK_NAME_TO_ACTION_TYPE_MAP.containsKey(genericTaskName)) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        this.genericTaskName = genericTaskName;
    }

    static {
        TASK_NAME_TO_ACTION_TYPE_MAP.put(EXPIRE_PROTOCOL, "302");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(EXPIRE_UNAVAILABLE_PROTOCOL, "302");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(SUSPEND_PROTOCOL, "307");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(SUSPEND_UNAVAILABLE_PROTOCOL, "307");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(TERMINATE_PROTOCOL, "306");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(TERMINATE_UNAVAILBLE_PROTOCOL, "306");
        TASK_NAME_TO_ROLE_NAME_MAP = new HashMap();
        TASK_NAME_TO_ROLE_NAME_MAP.put(EXPIRE_PROTOCOL, "Perform IACUC Actions on Protocol");
        TASK_NAME_TO_ROLE_NAME_MAP.put(EXPIRE_UNAVAILABLE_PROTOCOL, "Perform IACUC Actions on Protocol");
        TASK_NAME_TO_ROLE_NAME_MAP.put(SUSPEND_PROTOCOL, "Perform IACUC Actions on Protocol");
        TASK_NAME_TO_ROLE_NAME_MAP.put(SUSPEND_UNAVAILABLE_PROTOCOL, "Perform IACUC Actions on Protocol");
        TASK_NAME_TO_ROLE_NAME_MAP.put(TERMINATE_PROTOCOL, "Perform IACUC Actions on Protocol");
        TASK_NAME_TO_ROLE_NAME_MAP.put(TERMINATE_UNAVAILBLE_PROTOCOL, "Perform IACUC Actions on Protocol");
    }
}

