/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.sql.Date;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -5078229085592345997L;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        IacucProtocolDocument iacucProtocolDocument = (IacucProtocolDocument)document;
        String userId = user.getPrincipalId();
        if (iacucProtocolDocument.getProtocol().getProtocolId() == null) {
            if (this.canCreateIacucProtocol(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "modifyIacucProtocol")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "viewIacucProtocol")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "maintainIacucProtocolOnlineReviews")) {
                editModes.add("maintainIacucProtocolOnlineReviews");
            }
            if (this.canViewReviewComments((Document)iacucProtocolDocument, user)) {
                editModes.add("viewReviewComments");
            }
            if (this.canEditReviewComments((Document)iacucProtocolDocument, user)) {
                editModes.add("canEditReviewComments");
            }
            if (this.canEditReviewAttachments((Document)iacucProtocolDocument, user)) {
                editModes.add("canEditReviewAttachments");
            }
        }
        return editModes;
    }

    public boolean canViewReviewComments(Document document, Person user) {
        ProtocolDocumentBase protocolDoc = (ProtocolDocumentBase)document;
        List participants = protocolDoc.getProtocol().getProtocolPersons();
        for (ProtocolPersonBase participant : participants) {
            String statusCode;
            if (!StringUtils.equalsIgnoreCase((String)(participant.getPersonId() + ""), (String)user.getPrincipalId()) || !(statusCode = protocolDoc.getProtocol().getProtocolStatusCode()).equalsIgnoreCase("101")) continue;
            return false;
        }
        return true;
    }

    public boolean canEditReviewComments(Document document, Person user) {
        IacucProtocolDocument protocolDoc = (IacucProtocolDocument)document;
        List reviews = this.getIacucProtocolOnlineReviewService().getProtocolReviews(protocolDoc.getProtocol().getProtocolNumber());
        if (reviews != null && reviews.size() > 0) {
            for (ProtocolOnlineReviewBase review : reviews) {
                ProtocolReviewer reviewer = review.getProtocolReviewer();
                if (!StringUtils.equalsIgnoreCase((String)reviewer.getPerson().getPersonId(), (String)user.getPrincipalId())) continue;
                if (this.isPrimarySecondary(reviewer)) {
                    return true;
                }
                if (!this.isCommitteeAndPastDeterminationDueDate(reviewer, review)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canEditReviewAttachments(Document document, Person user) {
        IacucProtocolDocument protocolDoc = (IacucProtocolDocument)document;
        List reviews = this.getIacucProtocolOnlineReviewService().getProtocolReviews(protocolDoc.getProtocol().getProtocolNumber());
        if (reviews != null && reviews.size() > 0) {
            for (ProtocolOnlineReviewBase review : reviews) {
                ProtocolReviewer reviewer = review.getProtocolReviewer();
                if (!StringUtils.equalsIgnoreCase((String)reviewer.getPerson().getPersonId(), (String)user.getPrincipalId())) continue;
                if (this.isPrimarySecondary(reviewer)) {
                    return true;
                }
                if (!this.isCommitteeAndPastDeterminationDueDate(reviewer, review)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPrimarySecondary(ProtocolReviewer reviewer) {
        return StringUtils.equalsIgnoreCase((String)reviewer.getReviewerTypeCode(), (String)"1") || StringUtils.equalsIgnoreCase((String)reviewer.getReviewerTypeCode(), (String)"2");
    }

    protected boolean isCommitteeAndPastDeterminationDueDate(ProtocolReviewer reviewer, ProtocolOnlineReviewBase review) {
        Date determinationDueDate;
        return StringUtils.equalsIgnoreCase((String)reviewer.getReviewerTypeCode(), (String)"3") && (determinationDueDate = ((IacucProtocolOnlineReview)review.getProtocolOnlineReviewDocument().getProtocolOnlineReview()).getDeterminationReviewDateDue()) != null && Calendar.getInstance().getTime().after(determinationDueDate);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get("onAmendAndRenewAllowNewProtocolDocument") != null) {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
            return true;
        }
        return this.canCreateIacucProtocol(user);
    }

    public boolean canOpen(Document document, Person user) {
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)document;
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            return this.canCreateIacucProtocol(user);
        }
        return this.canExecuteIacucProtocolTask(user.getPrincipalId(), (IacucProtocolDocument)document, "viewIacucProtocol");
    }

    private boolean canCreateIacucProtocol(Person user) {
        ApplicationTask task = new ApplicationTask("createIacucProtocol");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), (Task)task);
    }

    private boolean canExecuteIacucProtocolTask(String userId, IacucProtocolDocument doc, String taskName) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, doc.getIacucProtocol());
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, (Task)task);
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteIacucProtocolTask(user.getPrincipalId(), (IacucProtocolDocument)document, "modifyIacucProtocol");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canClose(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    public boolean canCancel(Document document, Person user) {
        return false;
    }

    public boolean canRoute(Document document, Person user) {
        return false;
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }

    protected IacucProtocolOnlineReviewService getIacucProtocolOnlineReviewService() {
        return (IacucProtocolOnlineReviewService)KraServiceLocator.getService(IacucProtocolOnlineReviewService.class);
    }
}

