/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.print;

import edu.mit.coeus.xml.iacuc.CommitteeDocument;
import edu.mit.coeus.xml.iacuc.CommitteeMasterDataType;
import edu.mit.coeus.xml.iacuc.CommitteeMemberRoleType;
import edu.mit.coeus.xml.iacuc.CommitteeMemberType;
import edu.mit.coeus.xml.iacuc.CommitteeType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.ProtocolType;
import edu.mit.coeus.xml.iacuc.ResearchAreaType;
import edu.mit.coeus.xml.iacuc.ScheduleSummaryType;
import edu.mit.coeus.xml.iacuc.ScheduleType;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.iacuc.committee.print.IacucScheduleXmlStream;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.printing.xmlstream.PrintBaseXmlStream;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;

public class IacucCommitteeXmlStream
extends PrintBaseXmlStream {
    private IacucScheduleXmlStream scheduleXmlStream;
    private IacucPrintXmlUtilService printXmlUtilService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        CommitteeBase committee = (CommitteeBase)printableBusinessObject;
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        CommitteeDocument committeeDocumentType = CommitteeDocument.Factory.newInstance();
        committeeDocumentType.setCommittee(this.getCommitteeCompleteDetails(committee));
        xmlObjectList.put("CommitteeBase", (XmlObject)committeeDocumentType);
        return xmlObjectList;
    }

    public CommitteeType getCommitteeCompleteDetails(CommitteeBase committee) {
        CommitteeType committeeType = CommitteeType.Factory.newInstance();
        this.setCommitteeMasterData(committee, committeeType.addNewCommitteeMasterData());
        this.setCommitteeMembers(committee, committeeType);
        this.setScheduleForcommittee(committee, committeeType);
        this.setCommitteeResearchArea(committee, committeeType);
        return committeeType;
    }

    private void setCommitteeResearchArea(CommitteeBase committee, CommitteeType committeeType) {
        List committeeResearchAreas = committee.getCommitteeResearchAreas();
        if (committeeResearchAreas.isEmpty()) {
            return;
        }
        for (CommitteeResearchAreaBase committeeResearchArea : committeeResearchAreas) {
            ResearchAreaType researchArea = committeeType.addNewResearchArea();
            researchArea.setResearchAreaCode(committeeResearchArea.getResearchAreaCode());
            researchArea.setResearchAreaDescription(committeeResearchArea.getResearchArea().getDescription());
        }
    }

    private void setScheduleForcommittee(CommitteeBase committee, CommitteeType committeeType) {
        java.util.Date currentDate = new java.util.Date();
        Boolean isRooster = committee.getPrintRooster();
        List vecSchedule = committee.getCommitteeSchedules();
        if (vecSchedule.isEmpty()) {
            return;
        }
        for (CommitteeScheduleBase scheduleDetailsBean : vecSchedule) {
            ScheduleSummaryType nextSchedule;
            ScheduleType scheduleType;
            Date scheduleDate = scheduleDetailsBean.getScheduledDate();
            int dateCount = scheduleDate.compareTo(currentDate);
            if (isRooster.booleanValue()) {
                scheduleType = committeeType.addNewSchedule();
                this.getScheduleXmlStream().setScheduleMasterData(scheduleDetailsBean, scheduleType.addNewScheduleMasterData());
                nextSchedule = scheduleType.addNewNextSchedule();
                this.getScheduleXmlStream().setNextSchedule(scheduleDetailsBean, nextSchedule.addNewScheduleMasterData());
            }
            if (isRooster.booleanValue() || dateCount <= 0) continue;
            scheduleType = committeeType.addNewSchedule();
            this.getScheduleXmlStream().setScheduleMasterData(scheduleDetailsBean, scheduleType.addNewScheduleMasterData());
            nextSchedule = scheduleType.addNewNextSchedule();
            this.getScheduleXmlStream().setNextSchedule(scheduleDetailsBean, nextSchedule.addNewScheduleMasterData());
        }
    }

    public void setCommitteeMembers(CommitteeBase committee, CommitteeType committeeType) {
        List committeeMemberships = committee.getCommitteeMemberships();
        if (committeeMemberships.isEmpty()) {
            return;
        }
        for (CommitteeMembershipBase membershipBean : committeeMemberships) {
            CommitteeMemberType committeeMember = committeeType.addNewCommitteeMember();
            this.setCommitteeMembershipType(membershipBean, committeeMember);
        }
    }

    public void setCommitteeMembers(CommitteeBase committee, ProtocolType.Submissions committeeType) {
        List committeeMemberships = committee.getCommitteeMemberships();
        if (committeeMemberships.isEmpty()) {
            return;
        }
        for (CommitteeMembershipBase membershipBean : committeeMemberships) {
            CommitteeMemberType committeeMember = committeeType.addNewCommitteeMember();
            this.setCommitteeMembershipType(membershipBean, committeeMember);
        }
    }

    private void setCommitteeMembershipType(CommitteeMembershipBase membershipBean, CommitteeMemberType committeeMember) {
        List vecMemRoles;
        membershipBean.refreshNonUpdateableReferences();
        this.setPersonType(membershipBean, committeeMember);
        committeeMember.setMemberStatus(membershipBean.isActive() ? "active" : "inactive");
        committeeMember.setMemberStatusStartDt(Calendar.getInstance());
        committeeMember.setMemberStatusEndDt(Calendar.getInstance());
        if (membershipBean.getTermEndDate() != null) {
            committeeMember.setTermEnd(this.getDateTimeService().getCalendar((java.util.Date)membershipBean.getTermEndDate()));
        }
        if (membershipBean.getTermStartDate() != null) {
            committeeMember.setTermStart(this.getDateTimeService().getCalendar((java.util.Date)membershipBean.getTermStartDate()));
        }
        if (membershipBean.getMembershipType() != null) {
            committeeMember.setMemberType(membershipBean.getMembershipType().getDescription());
        }
        committeeMember.setPaidMemberFlag(membershipBean.getPaidMember());
        List committeeMemResearchArea = membershipBean.getMembershipExpertise();
        if (committeeMemResearchArea != null) {
            for (CommitteeMembershipExpertiseBase committeeMemberExpertise : committeeMemResearchArea) {
                ResearchAreaType researchArea = committeeMember.addNewResearchArea();
                researchArea.setResearchAreaCode(committeeMemberExpertise.getResearchAreaCode());
                if (committeeMemberExpertise.getResearchArea() == null) continue;
                researchArea.setResearchAreaDescription(committeeMemberExpertise.getResearchArea().getDescription());
            }
        }
        if ((vecMemRoles = membershipBean.getMembershipRoles()) != null) {
            for (CommitteeMembershipRole committeeMembershipRole : vecMemRoles) {
                CommitteeMemberRoleType committeeMemRole = committeeMember.addNewCommitteeMemberRole();
                committeeMemRole.setMemberRoleCode(new BigInteger(String.valueOf(committeeMembershipRole.getMembershipRoleCode())));
                if (committeeMembershipRole.getMembershipRole() != null) {
                    committeeMemRole.setMemberRoleDesc(committeeMembershipRole.getMembershipRole().getDescription());
                }
                if (committeeMembershipRole.getStartDate() != null) {
                    committeeMemRole.setMemberRoleStartDt(this.getDateTimeService().getCalendar((java.util.Date)committeeMembershipRole.getStartDate()));
                }
                if (committeeMembershipRole.getEndDate() == null) continue;
                committeeMemRole.setMemberRoleEndDt(this.getDateTimeService().getCalendar((java.util.Date)committeeMembershipRole.getEndDate()));
            }
        }
    }

    private void setPersonType(CommitteeMembershipBase membershipBean, CommitteeMemberType committeeMember) {
        PersonType person = committeeMember.addNewPerson();
        boolean employeeFlag = membershipBean.getPerson() != null;
        person.setFacultyFlag(false);
        person.setEmployeeFlag(!employeeFlag);
        if (employeeFlag) {
            KcPerson personBean = membershipBean.getPerson();
            this.getPrintXmlUtilService().setPersonXml(personBean, person);
        } else {
            ProtocolPersonRolodexBase rolodexBean = membershipBean.getRolodex();
            this.getPrintXmlUtilService().setPersonXml(rolodexBean, person);
        }
    }

    public void setCommitteeMasterData(CommitteeBase committee, CommitteeMasterDataType committeeMasterDataType) {
        committeeMasterDataType.setCommitteeId(committee.getCommitteeId());
        committeeMasterDataType.setCommitteeName(committee.getCommitteeName());
        committeeMasterDataType.setHomeUnitNumber(committee.getHomeUnitNumber());
        committeeMasterDataType.setHomeUnitName(committee.getUnitName());
        committeeMasterDataType.setCommitteeTypeCode(new BigInteger(String.valueOf(committee.getCommitteeTypeCode())));
        committeeMasterDataType.setCommitteeTypeDesc(committee.getCommitteeType().getDescription());
        committeeMasterDataType.setScheduleDescription(committee.getScheduleDescription());
        committeeMasterDataType.setMinimumMembersRequired(new BigInteger(String.valueOf(committee.getMinimumMembersRequired())));
        committeeMasterDataType.setMaxProtocols(new BigInteger(String.valueOf(committee.getMaxProtocols())));
        committeeMasterDataType.setAdvSubmissionDays(new BigInteger(String.valueOf(committee.getAdvancedSubmissionDaysRequired())));
        if (committee.getReviewType() != null) {
            committeeMasterDataType.setDefaultReviewTypeCode(new BigInteger(String.valueOf(committee.getReviewTypeCode())));
            committeeMasterDataType.setDefaultReviewTypeDesc(committee.getReviewType().getDescription());
        }
    }

    public void setScheduleXmlStream(IacucScheduleXmlStream scheduleXmlStream) {
        this.scheduleXmlStream = scheduleXmlStream;
    }

    public IacucScheduleXmlStream getScheduleXmlStream() {
        return this.scheduleXmlStream;
    }

    public void setPrintXmlUtilService(IacucPrintXmlUtilService printXmlUtilService) {
        this.printXmlUtilService = printXmlUtilService;
    }

    public IacucPrintXmlUtilService getPrintXmlUtilService() {
        return this.printXmlUtilService;
    }
}

