/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.service.impl;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.kra.common.committee.print.service.CommitteePrintingServiceBase;
import org.kuali.kra.common.committee.service.impl.CommitteeBatchCorrespondenceServiceImplBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.committee.bo.IacucCommitteeBatchCorrespondence;
import org.kuali.kra.iacuc.committee.bo.IacucCommitteeBatchCorrespondenceDetail;
import org.kuali.kra.iacuc.committee.print.service.IacucCommitteePrintingService;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeBatchCorrespondenceService;
import org.kuali.kra.iacuc.correspondence.IacucBatchCorrespondence;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondence;
import org.kuali.kra.iacuc.notification.IacucBatchCorrespondenceNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class IacucCommitteeBatchCorrespondenceServiceImpl
extends CommitteeBatchCorrespondenceServiceImplBase
implements IacucCommitteeBatchCorrespondenceService {
    public CommitteeBatchCorrespondenceBase generateBatchCorrespondence(String batchCorrespondenceTypeCode, String committeeId, Date startDate, Date endDate) throws Exception {
        String protocolActionTypeCode;
        BatchCorrespondenceBase batchCorrespondence = null;
        List protocols = null;
        this.finalActionCounter = 0;
        IacucCommitteeBatchCorrespondence committeeBatchCorrespondence = new IacucCommitteeBatchCorrespondence(batchCorrespondenceTypeCode, committeeId, startDate, endDate);
        if (StringUtils.equals((String)batchCorrespondenceTypeCode, (String)"1")) {
            protocols = this.protocolDao.getExpiringProtocols(committeeId, startDate, endDate);
            protocolActionTypeCode = "111";
        } else if (StringUtils.equals((String)batchCorrespondenceTypeCode, (String)"2")) {
            protocols = this.protocolDao.getNotifiedProtocols(committeeId, startDate, endDate);
            protocolActionTypeCode = "112";
        } else {
            throw new IllegalArgumentException(batchCorrespondenceTypeCode);
        }
        batchCorrespondence = this.lookupBatchCorrespondence(batchCorrespondenceTypeCode);
        for (ProtocolBase protocol : protocols) {
            ProtocolCorrespondenceTypeBase protocolCorrespondenceType = this.getProtocolCorrespondenceTypeToGenerate(protocol, batchCorrespondence);
            if (protocolCorrespondenceType == null) continue;
            if (this.protocolCorrespondenceTemplateService.getProtocolCorrespondenceTemplate(committeeId, protocolCorrespondenceType.getProtoCorrespTypeCode()) == null) {
                LOG.warn((Object)("Correspondence template \"" + protocolCorrespondenceType.getDescription() + "\" is missing.  Correspondence for protocol " + protocol.getProtocolNumber() + " has not been generated.  Add the missing template and regenerate correspondence."));
                continue;
            }
            CommitteeBatchCorrespondenceDetailBase batchCorrespondenceDetail = this.createBatchCorrespondenceDetail(committeeId, protocol, protocolCorrespondenceType, committeeBatchCorrespondence.getCommitteeBatchCorrespondenceId(), protocolActionTypeCode);
            committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().add(batchCorrespondenceDetail);
            Long detailId = batchCorrespondenceDetail.getCommitteeBatchCorrespondenceDetailId();
            String description = protocolCorrespondenceType.getDescription();
            String userFullName = "";
            IacucBatchCorrespondenceNotificationRenderer renderer = new IacucBatchCorrespondenceNotificationRenderer((IacucProtocol)protocol, detailId, description, userFullName);
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)protocol, "111", "Renewal Reminder Generated", (IacucProtocolNotificationRenderer)renderer);
            context.setEmailAttachments(this.getEmailAttachments(batchCorrespondenceDetail.getProtocolCorrespondence()));
            this.kcNotificationService.sendNotification((NotificationContext)context);
        }
        this.businessObjectService.save((PersistableBusinessObject)committeeBatchCorrespondence);
        committeeBatchCorrespondence.setFinalActionCounter(this.finalActionCounter);
        return committeeBatchCorrespondence;
    }

    protected void applyFinalAction(ProtocolBase protocol, BatchCorrespondenceBase batchCorrespondence) throws Exception {
        IacucProtocolGenericActionBean actionBean = new IacucProtocolGenericActionBean(null, "");
        actionBean.setComments("Final action of batch Correspondence: " + batchCorrespondence.getDescription());
        if (StringUtils.equals((String)"307", (String)batchCorrespondence.getFinalActionTypeCode())) {
            try {
                protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                protocol.setProtocolDocument((ProtocolDocumentBase)((IacucProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber())));
            }
            this.protocolGenericActionService.suspend(protocol, (ProtocolGenericActionBean)actionBean);
            ++this.finalActionCounter;
        }
        if (StringUtils.equals((String)"302", (String)batchCorrespondence.getFinalActionTypeCode())) {
            try {
                protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                protocol.setProtocolDocument((ProtocolDocumentBase)((IacucProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber())));
            }
            this.protocolGenericActionService.expire(protocol, (ProtocolGenericActionBean)actionBean);
            ++this.finalActionCounter;
        }
    }

    protected Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook() {
        return IacucProtocolCorrespondence.class;
    }

    protected CommitteeBatchCorrespondenceDetailBase getNewCommitteeBatchCorrespondenceDetailInstanceHook() {
        return new IacucCommitteeBatchCorrespondenceDetail();
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, Object object, String protocolActionTypeCode) {
        return new IacucProtocolAction((IacucProtocol)protocol, null, protocolActionTypeCode);
    }

    protected ProtocolCorrespondence getNewProtocolCorrespondenceInstanceHook() {
        return new IacucProtocolCorrespondence();
    }

    protected Class<? extends BatchCorrespondenceBase> getBatchCorrespondenceBOClassHook() {
        return IacucBatchCorrespondence.class;
    }

    protected CommitteePrintingServiceBase getCommitteePrintingService() {
        return (CommitteePrintingServiceBase)KraServiceLocator.getService(IacucCommitteePrintingService.class);
    }
}

