/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.iacuc.IacucProtocolOnlineReviewDocument;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewFormBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolOnlineReviewForm
extends ProtocolOnlineReviewFormBase {
    private static final long serialVersionUID = -5729500189953414964L;
    private static Log LOG = LogFactory.getLog(IacucProtocolOnlineReviewForm.class);
    private static final Map<String, String> ONLINE_REVIEW_APPROVE_BUTTON_MAP = new HashMap();

    protected String getDefaultDocumentTypeName() {
        return "IacucProtocolOnlineReviewDocument";
    }

    protected String getLockRegion() {
        return "IACUC_PROTOCOL";
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        IacucProtocolOnlineReviewDocument doc = (IacucProtocolOnlineReviewDocument)this.getProtocolOnlineReviewDocument();
        String externalImageURL = "kra.externalizable.images.url";
        TaskAuthorizationService tas = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new IacucProtocolOnlineReviewTask("rejectIacucProtocolOnlineReview", (ProtocolOnlineReviewDocumentBase)doc)) && doc.getDocumentHeader().getWorkflowDocument().isEnroute() && "F".equals(doc.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode())) {
            String resubmissionImage = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_return_to_reviewer.gif";
            this.addExtraButton("methodToCall.rejectOnlineReview", resubmissionImage, "Return to reviewer");
        }
        return this.extraButtons;
    }

    public boolean getAdminFieldsEditable() {
        return ((KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class)).hasPermission(GlobalVariables.getUserSession().getPrincipalId(), (Permissionable)this.getProtocolOnlineReviewDocument().getProtocolOnlineReview().getProtocol(), "Maintain IACUC Protocol Online Reviews");
    }

    protected Map<String, String> getOnlineReviewApproveButtonMapHook() {
        return ONLINE_REVIEW_APPROVE_BUTTON_MAP;
    }

    protected Log getLogHook() {
        return LOG;
    }

    static {
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCAdminInitialReview", "buttonsmall_send_review_request.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCAdminReview", "buttonsmall_accept_review_comments.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IACUCOnlineReviewer", "buttonsmall_approve_this_review.gif");
    }
}

