/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.iacuc.IacucProtocolOnlineReviewDocument;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewer;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewServiceImplBase;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class IacucProtocolOnlineReviewServiceImpl
extends ProtocolOnlineReviewServiceImplBase
implements IacucProtocolOnlineReviewService {
    private static final Log LOG = LogFactory.getLog(IacucProtocolOnlineReviewServiceImpl.class);
    private KraWorkflowService kraWorkflowService;

    public boolean isProtocolInStateToBeReviewed(ProtocolBase protocol) {
        boolean isReviewable = false;
        ProtocolSubmissionBase submission = protocol.getProtocolSubmission();
        if (submission != null) {
            try {
                isReviewable = StringUtils.isNotEmpty((String)submission.getScheduleId());
                isReviewable &= StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") || StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"103");
                ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
                isReviewable &= this.kraWorkflowService.isDocumentOnNode((Document)protocolDocument, "IACUCReview");
            }
            catch (WorkflowException e) {
                String errorString = String.format("WorkflowException checking route node for creating new ProtocolOnlineReviewDocumentBase for protocol %s", submission.getProtocolNumber());
                LOG.error((Object)errorString, (Throwable)e);
                throw new RuntimeException(errorString, e);
            }
        }
        return isReviewable;
    }

    public void setKraWorkflowService(KraWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }

    public ProtocolOnlineReviewDocumentBase createAndRouteProtocolOnlineReviewDocument(ProtocolSubmissionBase protocolSubmission, ProtocolReviewer protocolReviewer, String documentDescription, String documentExplanation, String documentOrganizationDocumentNumber, String documentRouteAnnotation, boolean initialApproval, Date dateRequested, Date dateDue, String principalId) {
        ProtocolOnlineReviewDocumentBase document = null;
        try {
            if (LOG.isDebugEnabled()) {
                String protocolNumber = protocolSubmission.getProtocolNumber();
                Integer submissionNumber = protocolSubmission.getSubmissionNumber();
                LOG.debug((Object)String.format("Assigning online reviewer [%s] to protocol [%s].", protocolReviewer, protocolNumber));
                LOG.debug((Object)String.format("Current submission for protocol %s is %s.", protocolNumber, submissionNumber));
            }
            document = this.createProtocolOnlineReviewDocument(protocolSubmission, protocolReviewer, documentDescription, documentExplanation, documentOrganizationDocumentNumber, dateRequested, dateDue, principalId);
            this.documentService.routeDocument((Document)document, "Review Requested by PI during protocol submission.", new ArrayList());
            if (initialApproval) {
                this.documentService.approveDocument((Document)document, "", new ArrayList());
            }
        }
        catch (WorkflowException e) {
            String errorString = String.format("WorkflowException creating new ProtocolOnlineReviewDocumentBase for reviewer %s, protocol %s", protocolReviewer.getPersonId(), protocolSubmission.getProtocolNumber());
            LOG.error((Object)errorString, (Throwable)e);
            throw new RuntimeException(errorString, e);
        }
        return document;
    }

    public ProtocolOnlineReviewDocumentBase createProtocolOnlineReviewDocument(ProtocolSubmissionBase protocolSubmission, ProtocolReviewer protocolReviewer, String documentDescription, String documentExplanation, String documentOrganizationDocumentNumber, Date dateRequested, Date dateDue, String principalId) throws WorkflowException {
        Person person = this.personService.getPerson(principalId);
        WorkflowDocument workflowDocument = this.workflowDocumentService.createWorkflowDocument("IacucProtocolOnlineReviewDocument", person);
        DocumentHeader docHeader = new DocumentHeader();
        docHeader.setWorkflowDocument(workflowDocument);
        docHeader.setDocumentNumber(workflowDocument.getDocumentId().toString());
        IacucProtocolOnlineReviewDocument protocolReviewDocument = new IacucProtocolOnlineReviewDocument();
        protocolReviewDocument.setDocumentNumber(docHeader.getDocumentNumber());
        protocolReviewDocument.setDocumentHeader(docHeader);
        protocolReviewDocument.getProtocolOnlineReview().setProtocol(protocolSubmission.getProtocol());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolId(protocolSubmission.getProtocolId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolSubmission(protocolSubmission);
        protocolReviewDocument.getProtocolOnlineReview().setSubmissionIdFk(protocolSubmission.getSubmissionId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("S");
        protocolReviewDocument.getProtocolOnlineReview().setDateRequested(dateRequested == null ? new Date(new java.util.Date().getTime()) : dateRequested);
        protocolReviewDocument.getProtocolOnlineReview().setDateDue(dateDue);
        protocolReviewDocument.getProtocolOnlineReview().setProtocolReviewerId(protocolReviewer.getProtocolReviewerId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolReviewer(protocolReviewer);
        docHeader.setDocumentDescription(documentDescription);
        docHeader.setOrganizationDocumentNumber(documentOrganizationDocumentNumber);
        docHeader.setExplanation(documentExplanation);
        this.documentService.saveDocument((Document)protocolReviewDocument);
        return protocolReviewDocument;
    }

    public void removeOnlineReviewDocument(String personId, boolean nonEmployeeFlag, ProtocolSubmissionBase submission, String annotation) {
        ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument = this.getProtocolOnlineReviewDocument(personId, nonEmployeeFlag, submission);
        ProtocolOnlineReviewBase submissionsProtocolOnlineReview = null;
        for (ProtocolOnlineReviewBase rev : submission.getProtocolOnlineReviews()) {
            if (!rev.getProtocolOnlineReviewId().equals(protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolOnlineReviewId())) continue;
            submissionsProtocolOnlineReview = rev;
            break;
        }
        if (submissionsProtocolOnlineReview == null) {
            throw new IllegalStateException("Could not match OnlineReview document being removed to a protocolOnlineReview in the submission.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Processing request to remove online review for (personId=%s,nonEmployeeFlag=%s) from (protocol=%s,submission=%s)", personId, nonEmployeeFlag, submission.getProtocol().getProtocolNumber(), submission.getSubmissionNumber()));
        }
        if (protocolOnlineReviewDocument != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Found protocolOnlineReviewDocument %s, removing it.", protocolOnlineReviewDocument.getDocumentNumber()));
            }
            this.cancelOnlineReviewDocument(protocolOnlineReviewDocument, submission, annotation);
            submissionsProtocolOnlineReview.setProtocolOnlineReviewStatusCode("X");
            List reviewComments = protocolOnlineReviewDocument.getProtocolOnlineReview().getCommitteeScheduleMinutes();
            ArrayList deletedReviewComments = new ArrayList();
            this.reviewCommentsService.deleteAllReviewComments(reviewComments, deletedReviewComments);
            this.reviewCommentsService.saveReviewComments(reviewComments, deletedReviewComments);
            this.businessObjectService.save((PersistableBusinessObject)submissionsProtocolOnlineReview);
        } else {
            LOG.warn((Object)String.format("ProtocolBase Online Review document could not be found for (personId=%s,nonEmployeeFlag=%s) from (protocol=%s,submission=%s)", personId, nonEmployeeFlag, submission.getProtocol().getProtocolNumber(), submission.getSubmissionNumber()));
        }
    }

    protected String getProtocolOLRSavedStatusCodeHook() {
        return "S";
    }

    protected String getProtocolOLRRemovedCancelledStatusCodeHook() {
        return "X";
    }

    protected ProtocolOnlineReviewDocumentBase getNewProtocolOnlineReviewDocumentInstanceHook() {
        return new IacucProtocolOnlineReviewDocument();
    }

    protected String getProtocolOLRDocumentTypeHook() {
        return "IacucProtocolOnlineReviewDocument";
    }

    protected ProtocolReviewer createNewProtocolReviewerInstanceHook() {
        return new IacucProtocolReviewer();
    }

    protected Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewBOClassHook() {
        return IacucProtocolOnlineReview.class;
    }

    protected Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook() {
        return IacucProtocolSubmission.class;
    }
}

