/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolOnlineReviewDocument;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeScheduleService;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolOnlineReviewDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -5887926854171754314L;
    public static final String CAN_EDIT_REVIEW_TYPE = "canEditReviewType";
    public static final String CAN_EDIT_DETERMINATION = "canEditDetermination";
    public static final String CAN_SAVE = "canSave";
    private transient KraWorkflowService kraWorkflowService;
    private transient IacucCommitteeScheduleService committeeScheduleService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        IacucProtocolOnlineReviewDocument protocolOnlineReviewDocument = (IacucProtocolOnlineReviewDocument)document;
        String userId = user.getPrincipalId();
        if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "maintainIacucProtocolOnlineReviews")) {
            editModes.add("fullEntry");
            editModes.add(CAN_SAVE);
            editModes.add(CAN_EDIT_REVIEW_TYPE);
            editModes.add(CAN_EDIT_DETERMINATION);
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "modifyIacucProtocolOnlineReview")) {
            editModes.add("fullEntry");
            editModes.add(CAN_SAVE);
            if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "editIacucProtocolOnlineReviewType")) {
                editModes.add(CAN_EDIT_REVIEW_TYPE);
            }
            if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "editIacucProtocolOnlineReviewDetermination")) {
                editModes.add(CAN_EDIT_DETERMINATION);
            }
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "viewIacucProtocolOnlineReview")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        IacucProtocolDocument iacucProtocolDocument = (IacucProtocolDocument)protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocol().getProtocolDocument();
        boolean canAdministerCommitteeScheduleMinutes = this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "maintainIacucProtocolOnlineReviews");
        boolean canEdit = editModes.contains(CAN_SAVE);
        for (IacucCommitteeScheduleMinute minute : this.getCommitteeScheduleService().getMinutesByProtocol(protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolId())) {
            Long onlineReviewId;
            Long minuteOnlineReviewId = minute.getProtocolOnlineReviewIdFk();
            if (!ObjectUtils.equals((Object)minuteOnlineReviewId, (Object)(onlineReviewId = protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolOnlineReviewId()))) continue;
            boolean isCreator = StringUtils.equalsIgnoreCase((String)minute.getCreateUser(), (String)GlobalVariables.getUserSession().getPrincipalName());
            minute.setReadOnly(!canEdit || !canAdministerCommitteeScheduleMinutes && !isCreator);
        }
        return editModes;
    }

    private boolean canExecuteIacucProtocolTask(String userId, IacucProtocolDocument doc, String taskName) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, doc.getIacucProtocol());
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, (Task)task);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        IacucProtocolOnlineReviewDocument protocolOnlineReviewDocument = (IacucProtocolOnlineReviewDocument)document;
        if (protocolOnlineReviewDocument.getProtocolOnlineReview() == null) {
            return this.canCreateProtocolOnlineReview(user);
        }
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "viewProtocolOnlineReview");
    }

    private boolean canCreateProtocolOnlineReview(Person user) {
        ApplicationTask task = new ApplicationTask("createIacucProtocolOnlineReview");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), (Task)task);
    }

    private boolean canExecuteProtocolOnlineReviewTask(String userId, IacucProtocolOnlineReviewDocument doc, String taskName) {
        IacucProtocolOnlineReviewTask task = new IacucProtocolOnlineReviewTask(taskName, doc.getProtocolOnlineReview());
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, (Task)task);
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "modifyIacucProtocolOnlineReview") || this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "maintainIacucProtocolOnlineReviews");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    public boolean canCancel(Document document, Person user) {
        return false;
    }

    public boolean canRoute(Document document, Person user) {
        return false;
    }

    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user);
    }

    public boolean canDisapprove(Document document, Person user) {
        boolean result = super.canDisapprove(document, user);
        return result &= this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "maintainIacucProtocolOnlineReviews");
    }

    private KraWorkflowService getKraWorkflowService() {
        if (this.kraWorkflowService == null) {
            this.kraWorkflowService = (KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class);
        }
        return this.kraWorkflowService;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }

    public IacucCommitteeScheduleService getCommitteeScheduleService() {
        if (this.committeeScheduleService == null) {
            this.committeeScheduleService = (IacucCommitteeScheduleService)KraServiceLocator.getService(IacucCommitteeScheduleService.class);
        }
        return this.committeeScheduleService;
    }

    public void setCommitteeScheduleService(IacucCommitteeScheduleService committeeScheduleService) {
        this.committeeScheduleService = committeeScheduleService;
    }
}

