/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewAuthorizer;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ModifyIacucProtocolOnlineReviewDeterminationAuthorizer
extends IacucProtocolOnlineReviewAuthorizer {
    private static final Logger LOG = Logger.getLogger(ModifyIacucProtocolOnlineReviewDeterminationAuthorizer.class);

    public boolean isAuthorized(String userId, IacucProtocolOnlineReviewTask task) {
        boolean hasPermission = false;
        IacucProtocolOnlineReview protocolOnlineReview = (IacucProtocolOnlineReview)task.getProtocolOnlineReview();
        ProtocolOnlineReviewDocumentBase protocolDoc = null;
        try {
            protocolDoc = (ProtocolOnlineReviewDocumentBase)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
            if (protocolOnlineReview.getProtocolOnlineReviewId() != null && !protocolOnlineReview.getProtocolOnlineReviewDocument().isViewOnly()) {
                if (this.hasPermission(userId, (ProtocolOnlineReviewBase)protocolOnlineReview, "Maintain IACUC Protocol Online Reviews") && !protocolDoc.getDocumentHeader().getWorkflowDocument().isFinal()) {
                    hasPermission = true;
                } else if (this.hasPermission(userId, (ProtocolOnlineReviewBase)protocolOnlineReview, "Maintain IACUC Protocol Online Review Comments") && this.kraWorkflowService.isUserApprovalRequested((Document)protocolDoc, userId)) {
                    String reviewerTypeCode = protocolOnlineReview.getProtocolReviewer().getReviewerTypeCode();
                    if (StringUtils.equals((String)reviewerTypeCode, (String)"1") || StringUtils.equals((String)reviewerTypeCode, (String)"2")) {
                        hasPermission = true;
                    } else if (StringUtils.equals((String)reviewerTypeCode, (String)"3")) {
                        if (protocolOnlineReview.getDeterminationReviewDateDue() != null) {
                            Calendar today = Calendar.getInstance();
                            Calendar typeDueDate = Calendar.getInstance();
                            typeDueDate.setTime(protocolOnlineReview.getDeterminationReviewDateDue());
                            hasPermission = typeDueDate.before(today);
                        } else {
                            hasPermission = true;
                        }
                    }
                }
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)String.format("Could not find ProtocolOnlineReviewBase, document number %s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
        }
        return hasPermission;
    }
}

