/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolProceduresHelper
implements Serializable {
    private static final long serialVersionUID = -2090976351003068814L;
    protected IacucProtocolForm form;
    protected IacucProtocolStudyGroup newIacucProtocolStudyGroup;
    protected IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean;
    protected IacucProcedurePersonResponsible newIacucProcedurePersonResponsible;
    private List<IacucProcedure> allProcedures;
    protected int MAX_CATEGORY_COLUMNS = 3;

    public IacucProtocolProceduresHelper(IacucProtocolForm form) {
        this.setForm(form);
        this.setNewIacucProtocolStudyGroup(new IacucProtocolStudyGroup());
        this.setNewIacucProtocolStudyGroupBean(new IacucProtocolStudyGroupBean());
        this.setNewIacucProcedurePersonResponsible(new IacucProcedurePersonResponsible());
        this.setAllProcedures(new ArrayList());
        this.initializeIncludedProceduresAndCategories();
    }

    public void prepareView() {
        this.initializeIncludedProceduresAndCategories();
    }

    private void initializeIncludedProceduresAndCategories() {
        if (this.getAllProcedures().isEmpty()) {
            this.setAllProcedures(this.getIacucProtocolProcedureService().getAllProcedures());
        }
        if (this.getProtocol().getIacucProtocolStudyGroupBeans().isEmpty()) {
            this.getProtocol().setIacucProtocolStudyGroupBeans(this.getIacucProtocolProcedureService().getRevisedStudyGroupBeans(this.getProtocol(), this.getAllProcedures()));
        }
    }

    protected IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return (IacucProtocolProcedureService)KraServiceLocator.getService((String)"iacucProtocolProcedureService");
    }

    protected IacucProtocol getProtocol() {
        IacucProtocolDocument document = this.form.getIacucProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) Iacuc ProtocolDocument in ProtocolForm");
        }
        return document.getIacucProtocol();
    }

    public IacucProtocolForm getForm() {
        return this.form;
    }

    public void setForm(IacucProtocolForm form) {
        this.form = form;
    }

    public boolean isModifyProtocolProcedures() {
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocolProcedures", (IacucProtocol)this.form.getProtocolDocument().getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public IacucProtocolStudyGroup getNewIacucProtocolStudyGroup() {
        return this.newIacucProtocolStudyGroup;
    }

    public void setNewIacucProtocolStudyGroup(IacucProtocolStudyGroup newIacucProtocolStudyGroup) {
        this.newIacucProtocolStudyGroup = newIacucProtocolStudyGroup;
    }

    public List<IacucProcedure> getAllProcedures() {
        return this.allProcedures;
    }

    public void setAllProcedures(List<IacucProcedure> allProcedures) {
        this.allProcedures = allProcedures;
    }

    public int getMaxCategoriesInAColumn() {
        return (int)Math.ceil(this.getAllProcedures().size() / this.MAX_CATEGORY_COLUMNS);
    }

    public IacucProtocolStudyGroupBean getNewIacucProtocolStudyGroupBean() {
        return this.newIacucProtocolStudyGroupBean;
    }

    public void setNewIacucProtocolStudyGroupBean(IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean) {
        this.newIacucProtocolStudyGroupBean = newIacucProtocolStudyGroupBean;
    }

    public IacucProcedurePersonResponsible getNewIacucProcedurePersonResponsible() {
        return this.newIacucProcedurePersonResponsible;
    }

    public void setNewIacucProcedurePersonResponsible(IacucProcedurePersonResponsible newIacucProcedurePersonResponsible) {
        this.newIacucProcedurePersonResponsible = newIacucProcedurePersonResponsible;
    }
}

